/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.Cube;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public class MedianCut {
    static final int MAXCOLORS = 256;
    static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private Cube[] list;
    private int[] pixels32;
    private int width;
    private int height;
    private IndexColorModel cm;

    public MedianCut(int[] pixels, int width, int height) {
        this.pixels32 = pixels;
        this.width = width;
        this.height = height;
        IJ.showProgress(0.3);
        IJ.showStatus("Building 32x32x32 RGB histogram");
        this.hist = new int[32768];
        for (int i = 0; i < width * height; ++i) {
            int color16;
            int n = color16 = this.rgb(this.pixels32[i]);
            this.hist[n] = this.hist[n] + 1;
        }
    }

    public MedianCut(ColorProcessor ip) {
        this((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
    }

    int getColorCount() {
        int count = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= 0) continue;
            ++count;
        }
        return count;
    }

    Color getModalColor() {
        int max = 0;
        int c = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= max) continue;
            max = this.hist[i];
            c = i;
        }
        return new Color(this.red(c), this.green(c), this.blue(c));
    }

    private final int rgb(int c) {
        int r = (c & 0xF80000) >> 19;
        int g = (c & 0xF800) >> 6;
        int b = (c & 0xF8) << 7;
        return b | g | r;
    }

    private final int red(int x) {
        return (x & 0x1F) << 3;
    }

    private final int green(int x) {
        return x >> 2 & 0xF8;
    }

    private final int blue(int x) {
        return x >> 7 & 0xF8;
    }

    public Image convert(int maxcubes) {
        ImageProcessor ip = this.convertToByte(maxcubes);
        return ip.createImage();
    }

    public ImageProcessor convertToByte(int maxcubes) {
        int i;
        int longdim = 0;
        IJ.showStatus("Median cut");
        this.list = new Cube[256];
        this.histPtr = new int[32768];
        int ncubes = 0;
        Cube cube = new Cube();
        int color = 0;
        for (i = 0; i <= Short.MAX_VALUE; ++i) {
            if (this.hist[i] == 0) continue;
            this.histPtr[color++] = i;
            cube.count += this.hist[i];
        }
        cube.lower = 0;
        cube.upper = color - 1;
        cube.level = 0;
        this.Shrink(cube);
        this.list[ncubes++] = cube;
        while (ncubes < maxcubes) {
            int level = 255;
            int splitpos = -1;
            for (int k = 0; k <= ncubes - 1; ++k) {
                if (this.list[k].lower == this.list[k].upper || this.list[k].level >= level) continue;
                level = this.list[k].level;
                splitpos = k;
            }
            if (splitpos == -1) break;
            cube = this.list[splitpos];
            int lr = cube.rmax - cube.rmin;
            int lg = cube.gmax - cube.gmin;
            int lb = cube.bmax - cube.bmin;
            if (lr >= lg && lr >= lb) {
                longdim = 0;
            }
            if (lg >= lr && lg >= lb) {
                longdim = 1;
            }
            if (lb >= lr && lb >= lg) {
                longdim = 2;
            }
            this.reorderColors(this.histPtr, cube.lower, cube.upper, longdim);
            this.quickSort(this.histPtr, cube.lower, cube.upper);
            this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, longdim);
            int count = 0;
            for (i = cube.lower; i <= cube.upper - 1 && count < cube.count / 2; count += this.hist[color], ++i) {
                color = this.histPtr[i];
            }
            int median = i;
            Cube cubeA = new Cube();
            cubeA.lower = cube.lower;
            cubeA.upper = median - 1;
            cubeA.count = count;
            cubeA.level = cube.level + 1;
            this.Shrink(cubeA);
            this.list[splitpos] = cubeA;
            Cube cubeB = new Cube();
            cubeB.lower = median;
            cubeB.upper = cube.upper;
            cubeB.count = cube.count - count;
            cubeB.level = cube.level + 1;
            this.Shrink(cubeB);
            this.list[ncubes++] = cubeB;
            if (ncubes % 15 != 0) continue;
            IJ.showProgress(0.3 + 0.6 * (double)ncubes / (double)maxcubes);
        }
        IJ.showProgress(0.9);
        this.makeInverseMap(this.hist, ncubes);
        IJ.showProgress(0.95);
        return this.makeImage();
    }

    void Shrink(Cube cube) {
        int rmin = 255;
        int rmax = 0;
        int gmin = 255;
        int gmax = 0;
        int bmin = 255;
        int bmax = 0;
        for (int i = cube.lower; i <= cube.upper; ++i) {
            int color = this.histPtr[i];
            int r = this.red(color);
            int g = this.green(color);
            int b = this.blue(color);
            if (r > rmax) {
                rmax = r;
            }
            if (r < rmin) {
                rmin = r;
            }
            if (g > gmax) {
                gmax = g;
            }
            if (g < gmin) {
                gmin = g;
            }
            if (b > bmax) {
                bmax = b;
            }
            if (b >= bmin) continue;
            bmin = b;
        }
        cube.rmin = rmin;
        cube.rmax = rmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
        cube.bmin = bmin;
        cube.bmax = bmax;
    }

    void makeInverseMap(int[] hist, int ncubes) {
        int color;
        int i;
        Cube cube;
        int k;
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        IJ.showStatus("Making inverse map");
        for (k = 0; k <= ncubes - 1; ++k) {
            int b;
            int g;
            int r;
            cube = this.list[k];
            float bsum = 0.0f;
            float gsum = 0.0f;
            float rsum = 0.0f;
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.histPtr[i];
                r = this.red(color);
                rsum += (float)r * (float)hist[color];
                g = this.green(color);
                gsum += (float)g * (float)hist[color];
                b = this.blue(color);
                bsum += (float)b * (float)hist[color];
            }
            r = (int)(rsum / (float)cube.count);
            g = (int)(gsum / (float)cube.count);
            b = (int)(bsum / (float)cube.count);
            if (r == 248 && g == 248 && b == 248) {
                b = 255;
                g = 255;
                r = 255;
            }
            rLUT[k] = (byte)r;
            gLUT[k] = (byte)g;
            bLUT[k] = (byte)b;
        }
        this.cm = new IndexColorModel(8, ncubes, rLUT, gLUT, bLUT);
        for (k = 0; k <= ncubes - 1; ++k) {
            cube = this.list[k];
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.histPtr[i];
                hist[color] = k;
            }
        }
    }

    void reorderColors(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    a[i] = r << 10 | c >> 5;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 5 & 0x1F;
                    int b = c >> 10;
                    a[i] = g << 10 | b << 5 | r;
                }
                break;
            }
        }
    }

    void restoreColorOrder(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c >> 10;
                    a[i] = (c & 0x3FF) << 5 | r;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 10;
                    int b = c >> 5 & 0x1F;
                    a[i] = b << 10 | g << 5 | r;
                }
                break;
            }
        }
    }

    void quickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int t = a[lo];
                a[lo] = a[hi];
                a[hi] = t;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    ImageProcessor makeImage() {
        IJ.showStatus("Creating 8-bit image");
        byte[] pixels8 = new byte[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            int color16 = this.rgb(this.pixels32[i]);
            pixels8[i] = (byte)this.hist[color16];
        }
        ByteProcessor ip = new ByteProcessor(this.width, this.height, pixels8, this.cm);
        IJ.showProgress(1.0);
        return ip;
    }
}

