/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Range;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.MultiSheetSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;

public abstract class AbstractMultiSheetSpreadSheetReader
extends AbstractSpreadSheetReader
implements MultiSheetSpreadSheetReader {
    private static final long serialVersionUID = -7995524981221985397L;
    protected Range m_SheetRange;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sheets", "sheetRange", (Object)new Range("first"));
    }

    public void setSheetRange(Range value) {
        this.m_SheetRange = value;
        this.reset();
    }

    public Range getSheetRange() {
        return this.m_SheetRange;
    }

    public String sheetRangeTipText() {
        return "The range of sheets to load.";
    }

    public List<SpreadSheet> readRange(File file) {
        return this.readRange(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<SpreadSheet> readRange(String filename) {
        this.check();
        this.m_Stopped = false;
        this.m_LastError = null;
        reader = null;
        input = null;
        try {
            switch (1.$SwitchMap$adams$data$io$input$AbstractSpreadSheetReader$InputType[this.getInputType().ordinal()]) {
                case 1: {
                    result = this.doReadRange((File)new PlaceholderFile(filename));
                    ** break;
                }
                case 2: {
                    input = new FileInputStream(filename);
                    result = this.doReadRange(input);
                    ** break;
                }
                case 3: {
                    reader = new BufferedReader(new FileReader(filename));
                    result = this.doReadRange(reader);
                    ** break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + this.getInputType());
lbl21:
                    // 3 sources

                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                result = null;
                this.m_LastError = "Failed to read range '" + this.m_SheetRange + "' from '" + filename + "'!\n" + Utils.throwableToString((Throwable)e);
                e.printStackTrace();
            }
            catch (Throwable var6_6) {
                FileUtils.closeQuietly(reader);
                FileUtils.closeQuietly(input);
                throw var6_6;
            }
            FileUtils.closeQuietly((Reader)reader);
            FileUtils.closeQuietly((InputStream)input);
        }
        FileUtils.closeQuietly((Reader)reader);
        FileUtils.closeQuietly((InputStream)input);
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    public List<SpreadSheet> readRange(InputStream stream) {
        List<SpreadSheet> result;
        this.check();
        this.m_Stopped = false;
        this.m_LastError = null;
        try {
            switch (this.getInputType()) {
                case FILE: {
                    throw new IllegalStateException("Only supports reading from files, not input streams!");
                }
                case STREAM: {
                    result = this.doReadRange(stream);
                    break;
                }
                case READER: {
                    result = this.doReadRange(new BufferedReader(new InputStreamReader(stream)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + this.getInputType());
                }
            }
        }
        catch (Exception e) {
            result = null;
            this.m_LastError = "Failed to read range '" + this.m_SheetRange + "' from stream!\n" + Utils.throwableToString((Throwable)e);
            e.printStackTrace();
        }
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    public List<SpreadSheet> readRange(Reader r) {
        List<SpreadSheet> result;
        this.check();
        this.m_Stopped = false;
        this.m_LastError = null;
        try {
            switch (this.getInputType()) {
                case FILE: {
                    throw new IllegalStateException("Only supports reading from files, not input streams!");
                }
                case STREAM: {
                    result = this.doReadRange((InputStream)new ReaderInputStream(r));
                    break;
                }
                case READER: {
                    result = this.doReadRange(r);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + this.getInputType());
                }
            }
        }
        catch (Exception e) {
            result = null;
            this.m_LastError = "Failed to read range '" + this.m_SheetRange + "' from stream!\n" + Utils.throwableToString((Throwable)e);
            e.printStackTrace();
        }
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    protected List<SpreadSheet> doReadRange(File file) {
        return null;
    }

    protected List<SpreadSheet> doReadRange(Reader r) {
        return null;
    }

    protected List<SpreadSheet> doReadRange(InputStream in) {
        return null;
    }

    protected SpreadSheet doRead(File file) {
        List<SpreadSheet> result = this.doReadRange(file);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    protected SpreadSheet doRead(Reader r) {
        List<SpreadSheet> result = this.doReadRange(r);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    protected SpreadSheet doRead(InputStream in) {
        List<SpreadSheet> result = this.doReadRange(in);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }
}

