/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.management.LocaleHelper;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.input.SqlDumpSpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.ColumnNameConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SqlUtils;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;

public class SqlDumpSpreadSheetWriter
extends AbstractSpreadSheetWriter
implements AppendableSpreadSheetWriter {
    private static final long serialVersionUID = -3643934248575351045L;
    protected boolean m_Appending;
    protected SpreadSheet m_Header;
    protected boolean m_KeepExisting;
    protected boolean m_FileExists;
    protected String m_Table;
    protected Cell.ContentType[] m_Types;
    protected String[] m_ColumnNames;
    protected ColumnNameConversion m_ColumnNameConversion;
    protected String m_StringColumnSQL;
    protected int m_MaxStringLength;
    protected boolean m_AddCreateTable;
    protected boolean m_UseBackslashes;

    public String globalInfo() {
        return "Generates an SQL dump from the spreadsheet, which can be imported into a database.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("appending", "appending", (Object)false);
        this.m_OptionManager.add("keep-existing", "keepExisting", (Object)false);
        this.m_OptionManager.add("table", "table", (Object)"blah");
        this.m_OptionManager.add("column-name-conversion", "columnNameConversion", (Object)ColumnNameConversion.UPPER_CASE);
        this.m_OptionManager.add("max-string-length", "maxStringLength", (Object)50, (Number)1, null);
        this.m_OptionManager.add("string-column-sql", "stringColumnSQL", (Object)"VARCHAR(@MAX)");
        this.m_OptionManager.add("add-create-table", "addCreateTable", (Object)false);
        this.m_OptionManager.add("use-backslashes", "useBackslashes", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    public void reset() {
        super.reset();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    public String getFormatDescription() {
        return "SQL dump";
    }

    public String[] getFormatExtensions() {
        return new String[]{"sql"};
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new SqlDumpSpreadSheetReader();
    }

    public boolean canAppend(SpreadSheet sheet) {
        if (this.m_Header == null) {
            return this.m_KeepExisting;
        }
        return this.m_Header.equalsHeader(sheet) == null;
    }

    public void setAppending(boolean value) {
        this.m_Appending = value;
        this.reset();
    }

    public boolean isAppending() {
        return this.m_Appending;
    }

    public String appendingTipText() {
        return "If enabled, multiple spreadsheets with the same structure can be written to the same file.";
    }

    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    public String keepExistingTipText() {
        return "If enabled, any output file that exists when the writer is executed for the first time won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of columns, etc).";
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        return "The name of the table.";
    }

    public void setColumnNameConversion(ColumnNameConversion value) {
        this.m_ColumnNameConversion = value;
        this.reset();
    }

    public ColumnNameConversion getColumnNameConversion() {
        return this.m_ColumnNameConversion;
    }

    public String columnNameConversionTipText() {
        return "How to convert the column headers into SQL table column names.";
    }

    public void setMaxStringLength(int value) {
        this.m_MaxStringLength = value;
        this.reset();
    }

    public int getMaxStringLength() {
        return this.m_MaxStringLength;
    }

    public String maxStringLengthTipText() {
        return "The maximum length for strings to enforce; can be used as @MAX in the 'stringColumnsSQL' property.";
    }

    public void setStringColumnSQL(String value) {
        this.m_StringColumnSQL = value;
        this.reset();
    }

    public String getStringColumnSQL() {
        return this.m_StringColumnSQL;
    }

    public String stringColumnSQLTipText() {
        return "The SQL type to use for STRING columns in the CREATE statement; you can use the @MAX placeholder to tie the type to the 'naxStringLength' property; see also: http://en.wikipedia.org/wiki/SQL";
    }

    public void setAddCreateTable(boolean value) {
        this.m_AddCreateTable = value;
        this.reset();
    }

    public boolean getAddCreateTable() {
        return this.m_AddCreateTable;
    }

    public String addCreateTableTipText() {
        return "If enabled, a CREATE TABLE statement is output as well.";
    }

    public void setUseBackslashes(boolean value) {
        this.m_UseBackslashes = value;
        this.reset();
    }

    public boolean getUseBackslashes() {
        return this.m_UseBackslashes;
    }

    public String useBackslashesTipText() {
        return "If enabled, backslashes are used to escape single quotes, rather than doubling up the single quotes.";
    }

    public void setFileExists(boolean value) {
        this.m_FileExists = value;
    }

    public boolean getFileExists() {
        return this.m_FileExists;
    }

    protected synchronized String format(double value) {
        return Utils.doubleToString((double)value, (int)12, (Locale)LocaleHelper.getSingleton().getEnUS());
    }

    protected String quoteString(String s) {
        String result = this.m_UseBackslashes ? Utils.quote((String)s, (String)"'") : Utils.doubleUpQuotes((String)s, (char)'\'', (char[])new char[]{'\t', '\n'}, (String[])new String[]{"\\t", "\\n"});
        return result;
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        try {
            String newline = System.getProperty("line.separator");
            DateFormat dformat = content.getDateFormat();
            DateFormat dtformat = content.getDateTimeFormat();
            DateFormat tformat = content.getTimeFormat();
            if (this.m_Header == null) {
                for (int i = 0; i < content.getComments().size(); ++i) {
                    writer.write("-- " + (String)content.getComments().get(i) + newline);
                }
                writer.write(newline);
                SqlUtils.Writer wrter = new SqlUtils.Writer(content, this.m_Table, 255, this.m_ColumnNameConversion, this.m_StringColumnSQL, this.m_MaxStringLength);
                this.m_Types = wrter.getContentTypes();
                this.m_ColumnNames = wrter.getColumnNames();
                if (this.m_AddCreateTable) {
                    writer.write(wrter.getCreateStatement());
                    writer.write(newline);
                    writer.write(newline);
                }
                if (this.m_Appending) {
                    this.m_Header = content.getHeader();
                }
            }
            for (DataRow row : content.rows()) {
                boolean first = true;
                writer.write("INSERT INTO " + this.m_Table + " VALUES(");
                for (String keyd : content.getHeaderRow().cellKeys()) {
                    Cell cell = row.getCell(keyd);
                    if (!first) {
                        writer.write(",");
                    }
                    if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                        if (cell.isFormula()) {
                            writer.write(this.format(cell.toDouble()));
                        } else {
                            switch (cell.getContentType()) {
                                case STRING: {
                                    writer.write(this.quoteString(cell.getContent()));
                                    break;
                                }
                                case LONG: {
                                    writer.write(this.format(cell.toLong().longValue()));
                                    break;
                                }
                                case DOUBLE: {
                                    writer.write(this.format(cell.toDouble()));
                                    break;
                                }
                                case DATE: {
                                    writer.write(this.quoteString(dformat.format(cell.toDate())));
                                    break;
                                }
                                case DATETIME: {
                                    writer.write(this.quoteString(dtformat.format((Date)cell.toDateTime())));
                                    break;
                                }
                                case TIME: {
                                    writer.write(this.quoteString(tformat.format((Date)cell.toTime())));
                                    break;
                                }
                                case BOOLEAN: {
                                    writer.write(this.quoteString(cell.toBoolean().toString()));
                                    break;
                                }
                                default: {
                                    writer.write(this.quoteString(cell.toString()));
                                    break;
                                }
                            }
                        }
                    } else {
                        writer.write("NULL");
                    }
                    first = false;
                }
                writer.write(");");
                writer.write(newline);
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to write data!", e);
        }
        return result;
    }
}

