/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;

public abstract class AbstractRowScore
extends AbstractOptionHandler {
    private static final long serialVersionUID = 3225015615927453223L;
    protected String m_LastError;

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    public abstract int getNumScores();

    protected String check(SpreadSheet sheet, int rowIndex) {
        String result = null;
        if (sheet == null) {
            result = "No data provided!";
        }
        if (result == null && rowIndex >= sheet.getRowCount()) {
            result = "Row index out of bounds: " + rowIndex;
        }
        return result;
    }

    protected abstract Double[] doCalculateScore(SpreadSheet var1, int var2);

    public Double[] calculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = null;
        this.m_LastError = this.check(sheet, rowIndex);
        if (this.m_LastError == null && (result = this.doCalculateScore(sheet, rowIndex)) == null && this.m_LastError == null) {
            this.m_LastError = "Error occurred calculating score!";
        }
        return result;
    }
}

