/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.base.BaseString;
import adams.core.io.AbstractPdfProclet;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import java.io.File;

public class ImagePdfProclet
extends AbstractPdfProclet {
    private static final long serialVersionUID = 3962046484864891107L;
    protected int m_Rotation;
    protected double m_Scale;

    public String globalInfo() {
        return "Adds GIF, JPEG and PNG image files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rotation", "rotation", (Object)0, (Number)0, (Number)360);
        this.m_OptionManager.add("scale", "scale", (Object)1.0, (Number)0.0, (Number)1.0);
    }

    public void setRotation(int value) {
        if (value >= 0 && value <= 360) {
            this.m_Rotation = value;
            this.reset();
        } else {
            this.getLogger().warning("Degrees must be from 0 to 360!");
        }
    }

    public int getRotation() {
        return this.m_Rotation;
    }

    public String rotationTipText() {
        return "The rotation in degrees.";
    }

    public void setScale(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_Scale = value;
            this.reset();
        } else {
            this.getLogger().warning("Scale must satisfy 0 <= x <= 1!");
        }
    }

    public double getScale() {
        return this.m_Scale;
    }

    public String scaleTipText() {
        return "The scaling factor for the image, ie, scaling it to the page dimensions; use 0 to turn scaling off.";
    }

    @Override
    public BaseString[] getExtensions() {
        return new BaseString[]{new BaseString("gif"), new BaseString("jpg"), new BaseString("jpeg"), new BaseString("png")};
    }

    @Override
    protected boolean doProcess(Document doc, AbstractPdfProclet.DocumentState state, File file) throws Exception {
        boolean result = this.addFilename(doc, state, file);
        if (!result) {
            return result;
        }
        Image image = Image.getInstance((String)file.getAbsolutePath());
        if (this.m_Rotation != 0) {
            image.setRotationDegrees((float)this.m_Rotation);
            image.rotate();
        }
        if (this.m_Scale > 0.0) {
            float scale = (float)this.m_Scale;
            image.scaleToFit(doc.getPageSize().getWidth() * scale, doc.getPageSize().getHeight() * scale);
        }
        if (result = doc.add((Element)image)) {
            state.contentAdded();
        }
        return result;
    }
}

