/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.base.BaseString;
import adams.core.io.AbstractPdfProclet;
import adams.core.io.FileUtils;
import adams.core.io.PdfFont;
import adams.core.io.VariableFileExtensionPdfProclet;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import java.awt.Color;
import java.io.File;
import java.util.List;

public class PlainTextPdfProclet
extends AbstractPdfProclet
implements VariableFileExtensionPdfProclet {
    private static final long serialVersionUID = 3962046484864891107L;
    protected PdfFont m_FontContent;
    protected Color m_ColorContent;
    protected BaseString[] m_Extensions;

    public String globalInfo() {
        return "Adds plain-text files line by line.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("font-content", "fontContent", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("color-content", "colorContent", (Object)Color.BLACK);
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("txt")});
    }

    public void setFontContent(PdfFont value) {
        this.m_FontContent = value;
        this.reset();
    }

    public PdfFont getFontContent() {
        return this.m_FontContent;
    }

    public String fontContentTipText() {
        return "The font to use for the file content.";
    }

    public void setColorContent(Color value) {
        this.m_ColorContent = value;
        this.reset();
    }

    public Color getColorContent() {
        return this.m_ColorContent;
    }

    public String colorContentTipText() {
        return "The color to use for the content.";
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    @Override
    protected boolean doProcess(Document doc, AbstractPdfProclet.DocumentState state, File file) throws Exception {
        boolean result = this.addFilename(doc, state, file);
        if (!result) {
            return result;
        }
        List paragraphs = FileUtils.loadFromFile((File)file);
        for (int i = 0; i < paragraphs.size() && (result = doc.add((Element)new Paragraph((String)paragraphs.get(i), this.m_FontContent.toFont(this.m_ColorContent)))); ++i) {
            state.contentAdded();
        }
        return result;
    }
}

