/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfstamp;

import adams.core.io.PlaceholderFile;
import adams.flow.transformer.pdfstamp.AbstractPageRangeStamper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfStamper;
import java.util.logging.Level;

public class Image
extends AbstractPageRangeStamper {
    private static final long serialVersionUID = -2687932798037862212L;
    protected PlaceholderFile m_Image;
    protected float m_X;
    protected float m_Y;
    protected float m_Rotation;
    protected float m_Scale;

    public String globalInfo() {
        return "Places the image at the specified location.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image", "image", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("rotation", "rotation", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(360.0f));
        this.m_OptionManager.add("scale", "scale", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));
    }

    public void setImage(PlaceholderFile value) {
        this.m_Image = value;
        this.reset();
    }

    public PlaceholderFile getImage() {
        return this.m_Image;
    }

    public String imageTipText() {
        return "The image to use as stamp.";
    }

    public void setX(float value) {
        this.m_X = value;
        this.reset();
    }

    public float getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position.";
    }

    public void setY(float value) {
        this.m_Y = value;
        this.reset();
    }

    public float getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position.";
    }

    public void setRotation(float value) {
        this.m_Rotation = value;
        this.reset();
    }

    public float getRotation() {
        return this.m_Rotation;
    }

    public String rotationTipText() {
        return "The rotation in degrees, counterclockwise.";
    }

    public void setScale(float value) {
        if (value >= 0.0f && value <= 1.0f) {
            this.m_Scale = value;
            this.reset();
        } else {
            this.getLogger().warning("Scale must satisfy 0 <= x <= 1!");
        }
    }

    public float getScale() {
        return this.m_Scale;
    }

    public String scaleTipText() {
        return "The scaling factor for the image, ie, scaling it to the page dimensions; use 0 to turn scaling off.";
    }

    @Override
    protected void doStamp(PdfStamper stamper, int page) {
        PdfContentByte canvas = stamper.getOverContent(page + 1);
        try {
            com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((String)this.m_Image.getAbsolutePath());
            image.setAbsolutePosition(this.m_X, this.m_Y);
            if (this.m_Rotation != 0.0f) {
                image.setRotationDegrees(this.m_Rotation);
                image.rotate();
            }
            if (this.m_Scale > 0.0f) {
                image.scaleToFit(stamper.getReader().getPageSize(page + 1).getWidth() * this.m_Scale, stamper.getReader().getPageSize(page + 1).getHeight() * this.m_Scale);
            }
            canvas.addImage(image);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to insert image: " + this.m_Image, e);
        }
    }
}

