/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.core.Instance;
import weka.core.Utils;

public class DACModule
extends ErrorModule {
    protected Instance previousInstance;
    protected double[] m_correct;
    protected double[] m_directionsCount;

    @Override
    public String getEvalName() {
        return "DAC";
    }

    @Override
    public String getDescription() {
        return "Direction accuracy";
    }

    @Override
    public String getDefinition() {
        return "count(sign(actual_current - actual_previous) == sign(pred_current - pred_previous)) / N";
    }

    @Override
    public void evaluateForInstance(List<NumericPrediction> forecasts, Instance inst) throws Exception {
        super.evaluateForInstance(forecasts, inst);
        if (((List)this.m_predictions.get(0)).size() > 1) {
            for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
                NumericPrediction currentForI = (NumericPrediction)((List)this.m_predictions.get(i)).get(((List)this.m_predictions.get(i)).size() - 1);
                NumericPrediction previousForI = (NumericPrediction)((List)this.m_predictions.get(i)).get(((List)this.m_predictions.get(i)).size() - 2);
                if (Utils.isMissingValue((double)currentForI.predicted()) || Utils.isMissingValue((double)previousForI.predicted()) || Utils.isMissingValue((double)currentForI.actual()) || Utils.isMissingValue((double)previousForI.actual())) continue;
                double predictedDirection = currentForI.predicted() - previousForI.predicted();
                double actualDirection = currentForI.actual() - previousForI.actual();
                if (actualDirection > 0.0 && predictedDirection > 0.0) {
                    int n = i;
                    this.m_correct[n] = this.m_correct[n] + 1.0;
                } else if (actualDirection < 0.0 && predictedDirection < 0.0) {
                    int n = i;
                    this.m_correct[n] = this.m_correct[n] + 1.0;
                } else if (actualDirection == 0.0 && predictedDirection == 0.0) {
                    int n = i;
                    this.m_correct[n] = this.m_correct[n] + 1.0;
                }
                int n = i;
                this.m_directionsCount[n] = this.m_directionsCount[n] + 1.0;
            }
        } else {
            this.m_correct = new double[this.m_targetFieldNames.size()];
            this.m_directionsCount = new double[this.m_targetFieldNames.size()];
        }
    }

    @Override
    public double[] calculateMeasure() throws Exception {
        int i;
        double[] result = new double[this.m_targetFieldNames.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = Utils.missingValue();
        }
        for (i = 0; i < this.m_targetFieldNames.size(); ++i) {
            if (!(this.m_directionsCount[i] > 0.0)) continue;
            result[i] = this.m_correct[i] / this.m_directionsCount[i] * 100.0;
        }
        return result;
    }
}

