/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.Utils;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.IntArrayMatrixView;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class LaplaceOfGaussian
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 8400999643470579756L;
    protected int m_Size;
    protected double m_Sigma;
    protected double[][] m_Matrix;

    public String globalInfo() {
        return "Applies the Laplacian of Gaussian (LoG) to the image, using the following formula\n\n(x^2 + y^2 - 2*sigma^2) / sigma^4 * exp(-(x^2 +y^2) / (2*sigma^2)\n\nFor more information on LoG, see:\nhttp://fourier.eng.hmc.edu/e161/lectures/gradient/node8.html";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "size", (Object)5, (Number)1, null);
        this.m_OptionManager.add("sigma", "sigma", (Object)1.0, (Number)0.0, null);
    }

    protected void reset() {
        super.reset();
        this.m_Matrix = null;
    }

    public void setSize(int value) {
        if (value > 0 && value % 2 == 1) {
            this.m_Size = value;
            this.reset();
        } else {
            this.getLogger().warning("Size of matrix must be >0 and an odd number, provided: " + value);
        }
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size of the matrix (rows and columns); must be a positive, odd number.";
    }

    public void setSigma(double value) {
        if (value > 0.0) {
            this.m_Sigma = value;
            this.reset();
        } else {
            this.getLogger().warning("Sigma must be >0, provided: " + value);
        }
    }

    public double getSigma() {
        return this.m_Sigma;
    }

    public String sigmaTipText() {
        return "The sigma value.";
    }

    protected double[][] calcMatrix() {
        double[][] result = new double[this.m_Size][this.m_Size];
        int from = -(this.m_Size / 2);
        int to = from + this.m_Size;
        for (int y = from; y < to; ++y) {
            for (int x = from; x < to; ++x) {
                double z;
                result[y - from][x - from] = z = Math.exp((double)(-(x * x + y * y)) / (2.0 * this.m_Sigma * this.m_Sigma)) * ((double)(x * x + y * y) - 2.0 * this.m_Sigma * this.m_Sigma) / Math.pow(this.m_Sigma, 4.0);
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Matrix: " + Utils.arrayToString((Object)result));
        }
        return result;
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        if (this.m_Matrix == null) {
            this.m_Matrix = this.calcMatrix();
        }
        IntArrayMatrixView matrixIn = BufferedImageHelper.getPixelMatrix((BufferedImage)((BufferedImage)img.getImage()));
        int offset = this.m_Size / 2;
        IntArrayMatrixView matrixOut = new IntArrayMatrixView(matrixIn.getWidth() - offset * 2, matrixIn.getHeight() - offset * 2);
        int[] combined = new int[4];
        for (int y = offset; y < matrixIn.getHeight() - offset; ++y) {
            for (int x = offset; x < matrixIn.getWidth() - offset; ++x) {
                double r = 0.0;
                double g = 0.0;
                double b = 0.0;
                double a = 0.0;
                for (int m_y = y - offset; m_y < y + offset; ++m_y) {
                    for (int m_x = x - offset; m_x < x + offset; ++m_x) {
                        int[] rgba = matrixIn.getRGBA(x, y);
                        r += (double)rgba[0] * this.m_Matrix[m_y - y + offset][m_x - x + offset];
                        g += (double)rgba[1] * this.m_Matrix[m_y - y + offset][m_x - x + offset];
                        b += (double)rgba[2] * this.m_Matrix[m_y - y + offset][m_x - x + offset];
                        if (a != 0.0) continue;
                        a = rgba[3];
                    }
                }
                combined[0] = (int)r;
                combined[1] = (int)g;
                combined[2] = (int)b;
                combined[3] = (int)a;
                matrixOut.setRGBA(x - offset, y - offset, combined);
            }
        }
        ColorModel dstCM = ((BufferedImage)img.getImage()).getColorModel();
        BufferedImage image = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(img.getWidth(), img.getHeight()), dstCM.isAlphaPremultiplied(), null);
        image.setRGB(0, 0, matrixOut.getWidth(), matrixOut.getHeight(), matrixOut.getData(), 0, matrixOut.getWidth());
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        result[0].setImage((Object)image);
        return result;
    }
}

