/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.barcode.decode.AbstractBarcodeDecoder;
import adams.data.barcode.decode.PassThrough;
import adams.data.image.AbstractImageContainer;
import adams.data.text.TextContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class DecodeBarcode
extends AbstractTransformer {
    private static final long serialVersionUID = 6149942254926179607L;
    protected AbstractBarcodeDecoder m_Decoder;

    public String globalInfo() {
        return "Decodes the data in a barcode using the specified decoder.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("decoder", "decoder", (Object)new PassThrough());
    }

    public void setDecoder(AbstractBarcodeDecoder value) {
        this.m_Decoder = value;
        this.reset();
    }

    public AbstractBarcodeDecoder getDecoder() {
        return this.m_Decoder;
    }

    public String decoderTipText() {
        return "The decoder algorithm to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"decoder", (Object)((Object)this.m_Decoder));
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{TextContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            TextContainer cont = this.m_Decoder.decode((AbstractImageContainer)this.m_InputToken.getPayload());
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to extract barcode!", e);
        }
        return result;
    }
}

