/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.imagemagick.AbstractImageOperation;
import adams.data.imagemagick.im.NoOp;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class ImageMagickOperation
extends AbstractTransformer
implements ProvenanceSupporter,
FileWriter {
    private static final long serialVersionUID = 3690378527551302472L;
    protected AbstractImageOperation m_Operation;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Converts an image using the specified ImageMagick operation.\n\nNB: Uses im4java, i.e., ImageMagick (http://www.imagemagick.org/) executables must be available on the PATH.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new NoOp());
        this.m_OptionManager.add("output", "outputFile", (Object)new PlaceholderFile("."));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation), (String)"op: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)", output: ");
        return result;
    }

    public void setOperation(AbstractImageOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public AbstractImageOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The image operation to apply.";
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The file to write the output of the operation to.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("outputFile")) == null && this.m_OutputFile.isDirectory()) {
            result = this.m_OutputFile + " is a directory!";
        }
        return result;
    }

    protected String doExecute() {
        String input = this.m_InputToken.getPayload() instanceof File ? ((File)this.m_InputToken.getPayload()).getAbsolutePath() : (String)this.m_InputToken.getPayload();
        String result = this.m_Operation.apply(new PlaceholderFile(input), this.m_OutputFile);
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.m_OutputFile.getAbsolutePath());
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

