/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pixelselector;

import adams.data.report.Report;
import adams.flow.transformer.pixelselector.AbstractSingleColorPixelSelectorOverlay;
import adams.flow.transformer.pixelselector.BottomRightCorner;
import adams.flow.transformer.pixelselector.TopLeftCorner;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;
import java.awt.Point;

public class RectangleOverlay
extends AbstractSingleColorPixelSelectorOverlay {
    private static final long serialVersionUID = -5646722242616870109L;

    @Override
    protected String getGlobalInfo() {
        return "Simply highlights the selected pixel";
    }

    @Override
    public Class[] getSuggestedActions() {
        return new Class[]{TopLeftCorner.class, BottomRightCorner.class};
    }

    protected Point getTopLeft() {
        Report report;
        Point result = null;
        if (this.m_Image != null && this.m_Image.hasReport() && (report = this.m_Image.getReport()).hasValue("Pixel.Top") && report.hasValue("Pixel.Left")) {
            result = new Point(report.getDoubleValue("Pixel.Left").intValue(), report.getDoubleValue("Pixel.Top").intValue());
        }
        return result;
    }

    protected Point getBottomRight() {
        Report report;
        Point result = null;
        if (this.m_Image != null && this.m_Image.hasReport() && (report = this.m_Image.getReport()).hasValue("Pixel.Bottom") && report.hasValue("Pixel.Right")) {
            result = new Point(report.getDoubleValue("Pixel.Right").intValue(), report.getDoubleValue("Pixel.Bottom").intValue());
        }
        return result;
    }

    public void imageChanged(ImagePanel.PaintPanel panel) {
    }

    @Override
    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        Point topLeft = this.getTopLeft();
        Point bottomRight = this.getBottomRight();
        if (topLeft == null || bottomRight == null) {
            return;
        }
        g.setColor(this.m_Color);
        g.drawRect((int)topLeft.getX() - 1, (int)topLeft.getY() - 1, (int)(bottomRight.getX() - topLeft.getX() + 2.0), (int)(bottomRight.getY() - topLeft.getY() + 2.0));
    }
}

