/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.base.BaseText;
import adams.data.image.BufferedImageContainer;
import adams.data.imagemagick.ImageMagickHelper;
import adams.flow.core.Token;
import adams.flow.transformer.ImageMagickTransformer;
import adams.gui.core.TextEditorPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageMagick
extends AbstractSelectedImagesFilter {
    private static final long serialVersionUID = 3840263834155992337L;
    protected TextEditorPanel m_Editor;

    public String getMenu() {
        return "Filter";
    }

    public String getCaption() {
        return "ImageMagick...";
    }

    public String getIconName() {
        return "imagemagick.png";
    }

    public boolean canExecute(ImagePanel panel) {
        return ImageMagickHelper.isConvertAvailable() && super.canExecute(panel);
    }

    protected JPanel createConfigurationPanel(ApprovalDialog dialog) {
        JPanel result = new JPanel(new BorderLayout());
        this.m_Editor = new TextEditorPanel();
        if (this.hasLastSetup()) {
            this.m_Editor.setContent((String)this.getLastSetup());
        } else {
            this.m_Editor.setContent("");
        }
        result.add((Component)new JLabel("Please enter the commands"), "North");
        result.add((Component)this.m_Editor, "Center");
        return result;
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.m_Editor.getContent();
    }

    protected BufferedImage filter(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getContent());
        ImageMagickTransformer transformer = new ImageMagickTransformer();
        transformer.setCommands(new BaseText(this.m_Editor.getContent()));
        this.m_FilterError = transformer.setUp();
        if (this.m_FilterError == null) {
            BufferedImageContainer input = new BufferedImageContainer();
            input.setImage((Object)image);
            transformer.input(new Token((Object)input));
            this.m_FilterError = transformer.execute();
            if (this.m_FilterError == null && transformer.hasPendingOutput()) {
                result = (BufferedImage)((BufferedImageContainer)transformer.output().getPayload()).getImage();
            }
            transformer.wrapUp();
            transformer.cleanUp();
        }
        return result;
    }
}

