/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.CloneHandler;
import java.io.Serializable;
import java.lang.reflect.Array;

public abstract class BaseObject
implements Comparable,
CloneHandler<BaseObject>,
Serializable {
    private static final long serialVersionUID = 4619009495177712405L;
    protected Comparable m_Internal;

    public BaseObject(String s) {
        this.initialize();
        this.setValue(s);
    }

    protected void initialize() {
    }

    @Override
    public BaseObject getClone() {
        BaseObject result;
        try {
            result = (BaseObject)this.getClass().newInstance();
            result.setValue(this.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public int compareTo(Object o) {
        BaseObject other;
        if (o == null) {
            return 1;
        }
        if (o instanceof String) {
            try {
                other = (BaseObject)this.getClass().newInstance();
                other.setValue((String)o);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 1;
            }
        } else {
            if (!(o instanceof BaseObject)) {
                return -1;
            }
            other = (BaseObject)o;
        }
        if (this.getInternal() == null && other.getInternal() == null) {
            return 0;
        }
        if (this.getInternal() == null) {
            return -1;
        }
        if (other.getInternal() == null) {
            return 1;
        }
        return this.getInternal().compareTo(other.getInternal());
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseObject)) {
            return false;
        }
        return this.compareTo((BaseObject)o) == 0;
    }

    public int hashCode() {
        return this.m_Internal.hashCode();
    }

    public Comparable getInternal() {
        return this.m_Internal;
    }

    public abstract boolean isValid(String var1);

    public abstract void setValue(String var1);

    public abstract String getValue();

    public abstract String getTipText();

    public String toString() {
        return this.getValue();
    }

    public static BaseObject newInstance(Class cls, String s) {
        BaseObject result;
        try {
            result = (BaseObject)cls.newInstance();
            if (result.isValid(s)) {
                result.setValue(s);
            } else {
                result = null;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate new instance of BaseObject-derived class with value '" + s + "':");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static String[] toStringArray(BaseObject[] array) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].getValue();
        }
        return result;
    }

    public static BaseObject[] toObjectArray(String[] array, Class cls) {
        Object result = Array.newInstance(cls, array.length);
        for (int i = 0; i < array.length; ++i) {
            try {
                BaseObject obj = (BaseObject)cls.newInstance();
                obj.setValue(array[i]);
                Array.set(result, i, obj);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to turn '" + array[i] + "' into a " + cls.getName() + " object:");
                e.printStackTrace();
            }
        }
        return (BaseObject[])result;
    }
}

