/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.AbstractFilenameGeneratorWithExtension;
import adams.core.io.PlaceholderFile;
import java.io.File;

public class SimpleFilenameGenerator
extends AbstractFilenameGeneratorWithExtension {
    private static final long serialVersionUID = 6313170021657883586L;
    protected String m_Prefix;
    protected String m_Suffix;

    @Override
    public String globalInfo() {
        return "Simple generator that assembles filename based on output dir, prefix, current object (string representation), suffix and extension.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("suffix", "suffix", "");
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use (before the object).";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The suffix to use (after the object).";
    }

    @Override
    public boolean canHandleNullObject() {
        return true;
    }

    @Override
    protected String doGenerate(Object obj) {
        return new PlaceholderFile(this.m_Directory.getAbsolutePath() + File.separator + this.m_Prefix + (obj == null ? "" : obj) + this.m_Suffix + this.m_Extension).getAbsolutePath();
    }
}

