/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.PlaceholderDirectory;
import adams.core.management.ProcessUtils;
import java.io.File;

public class TempUtils {
    public static final String PROPERTY_TMPDIR = "adams.io.tmpdir";
    protected static long m_TempFileCounter = 0L;
    protected static String m_TempDir = null;

    public static synchronized File createTempFile(PlaceholderDirectory dir, String prefix, String suffix) {
        ++m_TempFileCounter;
        String filename = dir == null ? TempUtils.getTempDirectory() + File.separator : dir.getAbsolutePath() + File.separator;
        if (prefix != null) {
            filename = filename + prefix;
        }
        filename = filename + Long.toHexString(System.nanoTime()) + "-" + Long.toHexString(ProcessUtils.getVirtualMachinePID()) + "-" + Long.toHexString(m_TempFileCounter);
        if (suffix != null) {
            filename = filename + suffix;
        }
        return new File(filename);
    }

    public static synchronized File createTempFile(String prefix, String suffix) {
        return TempUtils.createTempFile(null, prefix, suffix);
    }

    public static synchronized File createTempFile(String file) {
        return new File(TempUtils.getTempDirectoryStr() + File.separator + file);
    }

    public static synchronized String getTempDirectoryStr() {
        if (m_TempDir == null) {
            String dir = System.getProperty(PROPERTY_TMPDIR);
            if (dir == null) {
                dir = System.getProperty("java.io.tmpdir");
            } else {
                File file = new File(dir);
                if (!file.exists() && !file.mkdirs()) {
                    dir = System.getProperty("java.io.tmpdir");
                    System.err.println("Failed to create temp directory '" + file + "', reverting back to system's default: " + dir);
                }
            }
            m_TempDir = dir;
        }
        return m_TempDir;
    }

    public static File getTempDirectory() {
        return new File(TempUtils.getTempDirectoryStr());
    }
}

