/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.management.AbstractClassPathAugmenter;
import java.util.ArrayList;

public class ExternalResourceClassPathAugmenter
extends AbstractClassPathAugmenter {
    private static final long serialVersionUID = 3380177345627628995L;
    protected PlaceholderFile[] m_Files;
    protected PlaceholderDirectory[] m_Directories;

    @Override
    public String globalInfo() {
        return "Allows the user to add external jars and directories.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "files", new PlaceholderFile[0]);
        this.m_OptionManager.add("dir", "directories", new PlaceholderDirectory[0]);
    }

    public void setFiles(PlaceholderFile[] value) {
        this.m_Files = value;
        this.reset();
    }

    public PlaceholderFile[] getFiles() {
        return this.m_Files;
    }

    public String filesTipText() {
        return "The jar/zip files to add to the classpath.";
    }

    public void setDirectories(PlaceholderDirectory[] value) {
        this.m_Directories = value;
        this.reset();
    }

    public PlaceholderDirectory[] getDirectories() {
        return this.m_Directories;
    }

    public String directoriesTipText() {
        return "The directories with classes to add to the classpath.";
    }

    @Override
    public String[] getClassPathAugmentation() {
        ArrayList<String> result = new ArrayList<String>();
        for (PlaceholderFile placeholderFile : this.m_Files) {
            result.add(placeholderFile.getAbsolutePath());
        }
        for (PlaceholderFile placeholderFile : this.m_Directories) {
            result.add(placeholderFile.getAbsolutePath());
        }
        return result.toArray(new String[result.size()]);
    }
}

