/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversionToString;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMToString
extends AbstractConversionToString {
    private static final long serialVersionUID = 6744245717394758406L;
    protected BaseCharset m_Encoding;

    @Override
    public String globalInfo() {
        return "Turns a " + Node.class.getName() + " or " + Document.class.getName() + " DOM object into a String.\n" + "In case of " + Node.class.getName() + " objects, the owner " + "document is converted to String.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", new BaseCharset());
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use for the string.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "encoding", this.m_Encoding);
    }

    @Override
    public Class accepts() {
        return Node.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        Document doc = this.m_Input instanceof Document ? (Document)this.m_Input : ((Node)this.m_Input).getOwnerDocument();
        DOMSource dsource = new DOMSource(doc);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        StreamResult sresult = new StreamResult(ostream);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(dsource, sresult);
        return new String(ostream.toByteArray(), this.m_Encoding.charsetValue());
    }
}

