/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.flow.core.Unknown;

public class PrimitiveArrayToObjectArray
extends AbstractConversion {
    private static final long serialVersionUID = 7012073882235453335L;

    @Override
    public String globalInfo() {
        return "Converts a primitive array to its object counterpart.";
    }

    @Override
    public Class accepts() {
        return Unknown.class;
    }

    @Override
    public Class generates() {
        return Unknown.class;
    }

    protected Byte[] convert(byte[] array) {
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected Short[] convert(short[] array) {
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected Integer[] convert(int[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected Long[] convert(long[] array) {
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected Float[] convert(float[] array) {
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    protected Double[] convert(double[] array) {
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected Character[] convert(char[] array) {
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    @Override
    protected Object doConvert() throws Exception {
        if (this.m_Input instanceof byte[]) {
            return this.convert((byte[])this.m_Input);
        }
        if (this.m_Input instanceof int[]) {
            return this.convert((int[])this.m_Input);
        }
        if (this.m_Input instanceof long[]) {
            return this.convert((long[])this.m_Input);
        }
        if (this.m_Input instanceof double[]) {
            return this.convert((double[])this.m_Input);
        }
        if (this.m_Input instanceof float[]) {
            return this.convert((float[])this.m_Input);
        }
        if (this.m_Input instanceof short[]) {
            return this.convert((short[])this.m_Input);
        }
        if (this.m_Input instanceof char[]) {
            return this.convert((char[])this.m_Input);
        }
        this.getLogger().warning("Failed to convert array: " + Utils.classToString(this.m_Input.getClass()));
        return this.m_Input;
    }
}

