/*
 * Decompiled with CFR 0.152.
 */
package adams.data.distribution;

import adams.data.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class Gamma
extends AbstractRealDistribution {
    private static final long serialVersionUID = -1708992443868275973L;
    protected double m_Shape;
    protected double m_Scale;
    protected double m_InverseCumAccuracy;

    @Override
    public String globalInfo() {
        return "The Gamma distribution.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("shape", "shape", 0.0);
        this.m_OptionManager.add("scale", "scale", 1.0);
        this.m_OptionManager.add("inverse-cum-accuracy", "inverseCumAccuracy", 1.0E-9);
    }

    public void setShape(double value) {
        this.m_Shape = value;
        this.reset();
    }

    public double getShape() {
        return this.m_Shape;
    }

    public String shapeTipText() {
        return "The shape parameter.";
    }

    public void setScale(double value) {
        this.m_Scale = value;
        this.reset();
    }

    public double getScale() {
        return this.m_Scale;
    }

    public String scaleTipText() {
        return "The scale parameter.";
    }

    public void setInverseCumAccuracy(double value) {
        this.m_InverseCumAccuracy = value;
        this.reset();
    }

    public double getInverseCumAccuracy() {
        return this.m_InverseCumAccuracy;
    }

    public String inverseCumAccuracyTipText() {
        return "The inverse cumulative accuracy.";
    }

    @Override
    public RealDistribution getRealDistribution() {
        return new GammaDistribution(this.m_Shape, this.m_Scale, this.m_InverseCumAccuracy);
    }
}

