/*
 * Decompiled with CFR 0.152.
 */
package adams.data.distribution;

import adams.data.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class Normal
extends AbstractRealDistribution {
    private static final long serialVersionUID = -1708992443868275973L;
    protected double m_Mean;
    protected double m_StandardDeviation;

    @Override
    public String globalInfo() {
        return "The Normal distribution.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("mean", "mean", 0.0);
        this.m_OptionManager.add("standard-deviation", "standardDeviation", 1.0);
    }

    public void setMean(double value) {
        this.m_Mean = value;
        this.reset();
    }

    public double getMean() {
        return this.m_Mean;
    }

    public String meanTipText() {
        return "The mean.";
    }

    public void setStandardDeviation(double value) {
        this.m_StandardDeviation = value;
        this.reset();
    }

    public double getStandardDeviation() {
        return this.m_StandardDeviation;
    }

    public String standardDeviationTipText() {
        return "The standard deviation.";
    }

    @Override
    public RealDistribution getRealDistribution() {
        return new NormalDistribution(this.m_Mean, this.m_StandardDeviation);
    }
}

