/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.autocorrelation.AbstractAutoCorrelation;
import adams.data.autocorrelation.BruteForce;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import gnu.trove.list.array.TDoubleArrayList;

public abstract class AbstractAutocorrelation<T extends DataContainer>
extends AbstractFilter<T> {
    private static final long serialVersionUID = 7714239052976065971L;
    protected AbstractAutoCorrelation m_Algorithm;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", new BruteForce());
    }

    public void setAlgorithm(AbstractAutoCorrelation value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractAutoCorrelation getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The autocorrelation algorithm to use.";
    }

    protected abstract double getX(DataPoint var1);

    protected abstract double getY(DataPoint var1);

    protected abstract DataPoint newDataPoint(double var1, double var3);

    @Override
    protected void checkData(T data) {
        super.checkData(data);
    }

    @Override
    protected T processData(T data) {
        int i;
        boolean padded = false;
        TDoubleArrayList list = new TDoubleArrayList();
        for (i = 0; i < data.size(); ++i) {
            list.add(this.getY((DataPoint)data.toList().get(i)));
        }
        if (list.size() % 2 != 0) {
            padded = true;
            list.add(0.0);
        }
        double[] ac = this.m_Algorithm.correlate(list.toArray());
        DataContainer result = data.getHeader();
        for (i = 0; i < data.size(); ++i) {
            result.add(this.newDataPoint(this.getX((DataPoint)data.toList().get(i)), ac[i]));
        }
        if (padded) {
            double diff = this.getX((DataPoint)data.toList().get(data.size() - 1)) - this.getX((DataPoint)data.toList().get(data.size() - 2));
            result.add(this.newDataPoint(this.getX((DataPoint)data.toList().get(data.size() - 1)) + diff, ac[ac.length - 1]));
        }
        return (T)result;
    }
}

