/*
 * Decompiled with CFR 0.152.
 */
package adams.data.id;

import adams.core.NamedSetup;
import adams.data.id.AbstractIDFilenameGenerator;

public class NamedSetupIDGenerator
extends AbstractIDFilenameGenerator<Object> {
    private static final long serialVersionUID = -2406430384157062397L;
    protected NamedSetup m_Setup;
    protected AbstractIDFilenameGenerator m_ActualScheme;

    @Override
    public String globalInfo() {
        return "Applies an ID generator that is referenced via its global setup name (see 'NamedSetups').";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", new NamedSetup());
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    public void setSetup(NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getLogger().severe("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractIDFilenameGenerator getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractIDFilenameGenerator)this.m_Setup.getSetup();
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
        }
        return this.m_ActualScheme;
    }

    @Override
    protected String assemble(Object o) {
        return this.getActualScheme().assemble(o);
    }
}

