/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.Notes;
import adams.data.conversion.DOMToProperties;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.IntArrayMatrixView;
import adams.data.report.Report;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public class BufferedImageHelper {
    public static BufferedImage deepCopy(BufferedImage source) {
        BufferedImage result;
        if (source.getType() == 0) {
            ColorModel cm = source.getColorModel();
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            WritableRaster raster = source.copyData(null);
            result = new BufferedImage(cm, raster, isAlphaPremultiplied, null);
        } else {
            result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
            Graphics g = result.getGraphics();
            g.drawImage(source, 0, 0, null);
            g.dispose();
        }
        return result;
    }

    public static int[] getPixels(BufferedImage img) {
        int[] result = new int[img.getWidth() * img.getHeight()];
        int i = 0;
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                result[i] = img.getRGB(x, y);
                ++i;
            }
        }
        return result;
    }

    public static IntArrayMatrixView getPixelMatrix(BufferedImage img) {
        int[] data = new int[img.getWidth() * img.getHeight()];
        img.getRGB(0, 0, img.getWidth(), img.getHeight(), data, 0, img.getWidth());
        return new IntArrayMatrixView(data, img.getWidth(), img.getHeight());
    }

    public static int[] split(int pixel) {
        int[] result = new int[]{pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel >> 0 & 0xFF, pixel >> 24 & 0xFF};
        return result;
    }

    public static int combine(int[] rgba) {
        return BufferedImageHelper.combine(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static int combine(int r, int g, int b, int a) {
        return (r << 16) + (g << 8) + (b << 0) + (a << 24);
    }

    public static int[][] getRGBPixels(BufferedImage img) {
        int[][] result = new int[img.getWidth() * img.getHeight()][4];
        int i = 0;
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int pixel = img.getRGB(x, y);
                result[i][0] = pixel >> 16 & 0xFF;
                result[i][1] = pixel >> 8 & 0xFF;
                result[i][2] = pixel >> 0 & 0xFF;
                result[i][3] = pixel >> 24 & 0xFF;
                ++i;
            }
        }
        return result;
    }

    public static int[][] getPixelRaster(BufferedImage img) {
        int[][] result = new int[img.getHeight()][img.getWidth()];
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                result[y][x] = img.getRGB(x, y);
            }
        }
        return result;
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, Color targetColor, Color replacementColor) {
        return BufferedImageHelper.floodFill(img, startX, startY, targetColor.getRGB(), replacementColor.getRGB());
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, int targetColor, int replacementColor) {
        return BufferedImageHelper.floodFill(img, startX, startY, targetColor, replacementColor, new int[4]);
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, Color targetColor, Color replacementColor, int[] extent) {
        return BufferedImageHelper.floodFill(img, startX, startY, targetColor.getRGB(), replacementColor.getRGB(), extent);
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, int targetColor, int replacementColor, int[] extent) {
        if (img.getRGB(startX, startY) != targetColor) {
            extent[0] = -1;
            extent[1] = -1;
            extent[2] = -1;
            extent[3] = -1;
            return false;
        }
        extent[0] = startX;
        extent[1] = startY;
        extent[2] = startX;
        extent[3] = startY;
        LinkedList<int[]> queue = new LinkedList<int[]>();
        queue.add(new int[]{startX, startY});
        int width = img.getWidth();
        int height = img.getHeight();
        while (!queue.isEmpty()) {
            LinkedList<int[]> queueNew = new LinkedList<int[]>();
            for (int[] pos : queue) {
                int west;
                if (img.getRGB(pos[0], pos[1]) != targetColor) continue;
                int east = west = pos[0];
                while (west > 0 && img.getRGB(west - 1, pos[1]) == targetColor) {
                    --west;
                }
                while (east < width - 1 && img.getRGB(east + 1, pos[1]) == targetColor) {
                    ++east;
                }
                for (int i = west; i <= east; ++i) {
                    img.setRGB(i, pos[1], replacementColor);
                    if (pos[1] > 0 && img.getRGB(i, pos[1] - 1) == targetColor) {
                        queueNew.add(new int[]{i, pos[1] - 1});
                    }
                    if (pos[1] >= height - 1 || img.getRGB(i, pos[1] + 1) != targetColor) continue;
                    queueNew.add(new int[]{i, pos[1] + 1});
                }
                if (extent[0] > west) {
                    extent[0] = west;
                }
                if (extent[2] < east) {
                    extent[2] = east;
                }
                if (extent[1] > pos[1]) {
                    extent[1] = pos[1];
                }
                if (extent[3] >= pos[1]) continue;
                extent[3] = pos[1];
            }
            queue = queueNew;
        }
        return true;
    }

    public static ImageReader getReaderForFile(File file) {
        String suffix = FileUtils.getExtension(file);
        ImageReader result = BufferedImageHelper.getReaderForExtension(suffix);
        return result;
    }

    public static ImageReader getReaderForExtension(String ext) {
        ImageReader result = null;
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(ext);
        if (iter.hasNext()) {
            result = iter.next();
        }
        return result;
    }

    public static ImageWriter getWriterForFile(File file) {
        String suffix = FileUtils.getExtension(file);
        ImageWriter result = BufferedImageHelper.getWriterForExtension(suffix);
        return result;
    }

    public static ImageWriter getWriterForExtension(String ext) {
        ImageWriter result = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix(ext);
        if (iter.hasNext()) {
            result = iter.next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static BufferedImageContainer read(File file) {
        Object object;
        FileInputStream fis;
        ImageInputStream iis;
        block17: {
            Iterator<ImageReader> it;
            BufferedImageContainer result;
            block15: {
                BufferedImageContainer bufferedImageContainer2;
                block16: {
                    iis = null;
                    fis = null;
                    result = new BufferedImageContainer();
                    fis = new FileInputStream(file.getAbsoluteFile());
                    iis = ImageIO.createImageInputStream(fis);
                    it = ImageIO.getImageReaders(iis);
                    if (it.hasNext()) break block15;
                    System.err.println("No reader for this format: " + file);
                    bufferedImageContainer2 = null;
                    if (iis == null) break block16;
                    try {
                        iis.close();
                        iis = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                FileUtils.closeQuietly(fis);
                return bufferedImageContainer2;
            }
            ImageReader reader = it.next();
            reader.setInput(iis);
            IIOMetadata meta = reader.getImageMetadata(0);
            DOMToProperties convert = new DOMToProperties();
            convert.setStoreAttributes(true);
            convert.setSkipRoot(true);
            String[] formats = meta.getMetadataFormatNames();
            Properties props = new Properties();
            for (String format : formats) {
                convert.setInput(meta.getAsTree(format));
                if (convert.convert() != null) continue;
                props.add((Properties)convert.getOutput());
            }
            convert.cleanUp();
            result.setReport(Report.parseProperties(props));
            BufferedImage image = reader.read(0);
            result.setImage(image);
            reader = null;
            object = result;
            if (iis == null) break block17;
            try {
                iis.close();
                iis = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileUtils.closeQuietly(fis);
        return object;
        catch (Exception e) {
            BufferedImageContainer bufferedImageContainer3;
            block18: {
                try {
                    System.err.println("Failed to read image: " + file);
                    e.printStackTrace();
                    bufferedImageContainer3 = null;
                    if (iis == null) break block18;
                }
                catch (Throwable throwable) {
                    if (iis != null) {
                        try {
                            iis.close();
                            iis = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    FileUtils.closeQuietly(fis);
                    throw throwable;
                }
                try {
                    iis.close();
                    iis = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            FileUtils.closeQuietly(fis);
            return bufferedImageContainer3;
        }
    }

    public static String write(BufferedImage img, File file) {
        try {
            ImageIO.write((RenderedImage)img, FileUtils.getExtension(file), file.getAbsoluteFile());
        }
        catch (Exception e) {
            return "Failed to write image to '" + file + "': " + Utils.throwableToString(e);
        }
        return null;
    }

    public static BufferedImage convert(BufferedImage img, int type) {
        BufferedImage result;
        if (img.getType() != type) {
            result = new BufferedImage(img.getWidth(), img.getHeight(), type);
            Graphics2D g2d = result.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            g2d.dispose();
        } else {
            result = img;
        }
        return result;
    }

    public static int[][] histogram(BufferedImage img, boolean gray) {
        int[][] result;
        if (gray) {
            result = new int[1][256];
            img = BufferedImageHelper.convert(img, 10);
            int height = img.getHeight();
            int width = img.getWidth();
            int[] split = new int[1];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    split[0] = img.getRGB(x, y) >> 8 & 0xFF;
                    int[] nArray = result[0];
                    int n = split[0];
                    nArray[n] = nArray[n] + 1;
                }
            }
        } else {
            result = new int[4][256];
            img = BufferedImageHelper.convert(img, 6);
            int height = img.getHeight();
            int width = img.getWidth();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int[] split = BufferedImageHelper.split(img.getRGB(x, y));
                    for (int i = 0; i < split.length; ++i) {
                        int[] nArray = result[i];
                        int n = split[i];
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        return result;
    }

    public static int getPixelDepth(BufferedImage img) {
        switch (img.getType()) {
            case 5: {
                return 24;
            }
            case 6: 
            case 7: {
                return 32;
            }
            case 10: 
            case 12: 
            case 13: {
                return 8;
            }
            case 2: 
            case 3: {
                return 32;
            }
            case 1: 
            case 4: {
                return 24;
            }
            case 9: {
                return 15;
            }
            case 8: {
                return 16;
            }
            case 11: {
                return 16;
            }
        }
        return -1;
    }

    public static BufferedImageContainer toBufferedImageContainer(AbstractImageContainer cont) {
        BufferedImageContainer result;
        if (cont instanceof BufferedImageContainer) {
            result = (BufferedImageContainer)cont;
        } else {
            Report report = cont.getReport().getClone();
            Notes notes = cont.getNotes().getClone();
            result = new BufferedImageContainer();
            result.setImage(cont.toBufferedImage());
            result.setReport(report);
            result.setNotes(notes);
        }
        return result;
    }
}

