/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.ClassLister;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.FlowReader;
import adams.flow.core.Actor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;

public abstract class AbstractFlowReader
extends AbstractOptionHandler
implements FlowReader {
    private static final long serialVersionUID = 4828477005893179066L;
    protected List<String> m_Warnings;
    protected List<String> m_Errors;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Warnings = new ArrayList<String>();
        this.m_Errors = new ArrayList<String>();
    }

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    @Override
    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    protected abstract InputType getInputType();

    protected void check() {
        this.m_Warnings.clear();
        this.m_Errors.clear();
    }

    @Override
    public Actor read(File file) {
        return this.read(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Actor read(String filename) {
        this.check();
        reader = null;
        input = null;
        try {
            switch (1.$SwitchMap$adams$data$io$input$AbstractFlowReader$InputType[this.getInputType().ordinal()]) {
                case 1: {
                    result = this.doRead(new PlaceholderFile(filename));
                    ** break;
                }
                case 2: {
                    input = new FileInputStream(filename);
                    result = this.doRead(input);
                    ** break;
                }
                case 3: {
                    reader = new BufferedReader(new FileReader(filename));
                    result = this.doRead(reader);
                    ** break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + (Object)this.getInputType());
lbl19:
                    // 3 sources

                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                result = null;
                e.printStackTrace();
            }
            catch (Throwable var6_6) {
                if (!(this instanceof ChunkedSpreadSheetReader)) {
                    FileUtils.closeQuietly(reader);
                    FileUtils.closeQuietly(input);
                }
                throw var6_6;
            }
            if (!(this instanceof ChunkedSpreadSheetReader)) {
                FileUtils.closeQuietly(reader);
                FileUtils.closeQuietly(input);
            }
        }
        if (!(this instanceof ChunkedSpreadSheetReader)) {
            FileUtils.closeQuietly(reader);
            FileUtils.closeQuietly(input);
        }
        return result;
    }

    @Override
    public Actor read(InputStream stream) {
        Actor result;
        this.check();
        try {
            switch (this.getInputType()) {
                case FILE: {
                    throw new IllegalStateException("Only supports reading from files, not input streams!");
                }
                case STREAM: {
                    result = this.doRead(stream);
                    break;
                }
                case READER: {
                    result = this.doRead(new BufferedReader(new InputStreamReader(stream)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + (Object)((Object)this.getInputType()));
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Actor read(Reader r) {
        Actor result;
        this.check();
        try {
            switch (this.getInputType()) {
                case FILE: {
                    throw new IllegalStateException("Only supports reading from files, not input streams!");
                }
                case STREAM: {
                    result = this.doRead((InputStream)new ReaderInputStream(r));
                    break;
                }
                case READER: {
                    result = this.doRead(r);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + (Object)((Object)this.getInputType()));
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    protected Actor doRead(File file) {
        return null;
    }

    protected Actor doRead(Reader r) {
        return null;
    }

    protected Actor doRead(InputStream in) {
        return null;
    }

    @Override
    public List<String> getWarnings() {
        return this.m_Warnings;
    }

    @Override
    public List<String> getErrors() {
        return this.m_Errors;
    }

    public static String[] getReaders() {
        return ClassLister.getSingleton().getClassnames(FlowReader.class);
    }

    public static enum InputType {
        FILE,
        READER,
        STREAM;

    }
}

