/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.SimpleFilenameGenerator;
import adams.data.io.output.AbstractTextWriterWithEncoding;

public abstract class AbstractTextWriterWithFilenameGenerator
extends AbstractTextWriterWithEncoding {
    private static final long serialVersionUID = -6137430023471487081L;
    protected AbstractFilenameGenerator m_FilenameGenerator;
    protected boolean m_IgnoreName;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filename-generator", "filenameGenerator", new SimpleFilenameGenerator());
        this.m_OptionManager.add("ignore-name", "ignoreName", false);
    }

    public void setFilenameGenerator(AbstractFilenameGenerator value) {
        this.m_FilenameGenerator = value;
        this.reset();
    }

    public AbstractFilenameGenerator getFilenameGenerator() {
        return this.m_FilenameGenerator;
    }

    public String filenameGeneratorTipText() {
        return "The filename generator to use.";
    }

    public void setIgnoreName(boolean value) {
        this.m_IgnoreName = value;
        this.reset();
    }

    public boolean getIgnoreName() {
        return this.m_IgnoreName;
    }

    public String ignoreNameTipText() {
        return "If set to true, then the name of the content is ignored for generating the filename (useful when prefix or suffix is based on variables).";
    }

    protected String createFilename(String name) {
        String result = this.m_IgnoreName || name == null ? this.m_FilenameGenerator.generate("") : this.m_FilenameGenerator.generate(name);
        return result;
    }
}

