/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.DateTime;
import adams.core.DateUtils;
import adams.core.Time;
import adams.core.Utils;
import adams.data.spreadsheet.AbstractObjectHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.parser.SpreadSheetFormula;
import java.util.Date;
import java.util.HashMap;

public class DoubleCell
implements Cell {
    private static final long serialVersionUID = -3912508808391288142L;
    public static final String PREFIX_FORMULA = "=";
    public static final String FORMULA_ERROR = "#ERROR#";
    protected Row m_Owner;
    protected double m_Content;
    protected String m_Formula;
    protected Object m_Object;
    protected Cell.ContentType m_ContentType;

    public DoubleCell(Row owner) {
        this.m_Owner = owner;
        this.m_Formula = null;
        this.m_Object = null;
        if (this.m_Owner != null) {
            this.setContentAsString("");
        } else {
            this.setMissing();
        }
    }

    @Override
    public void setOwner(Row owner) {
        this.m_Owner = owner;
    }

    @Override
    public Row getOwner() {
        return this.m_Owner;
    }

    @Override
    public SpreadSheet getSpreadSheet() {
        return this.getOwner().getOwner();
    }

    @Override
    public void assign(Cell cell) {
        this.m_ContentType = cell.getContentType();
        if (cell.isFormula()) {
            this.setFormula(cell.getFormula());
        } else if (cell.isObject()) {
            this.setObject(cell.getObject());
        } else {
            switch (this.m_ContentType) {
                case STRING: {
                    String content = cell.getContent();
                    if (!cell.isMissing() && content.equals("?")) {
                        this.setContentAsString("'?'");
                        break;
                    }
                    this.setContentAsString(content);
                    break;
                }
                default: {
                    if (cell instanceof DoubleCell) {
                        this.m_Content = ((DoubleCell)cell).m_Content;
                        break;
                    }
                    this.setContent(cell.getContent());
                }
            }
        }
    }

    @Override
    public void setMissing() {
        this.m_Content = Double.NaN;
        this.m_Formula = null;
        this.m_Object = null;
        this.m_ContentType = Cell.ContentType.MISSING;
    }

    @Override
    public Cell setContent(Boolean value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value != false ? 1 : 0;
            this.m_ContentType = Cell.ContentType.BOOLEAN;
        }
        return this;
    }

    @Override
    public Cell setContent(Byte value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = Cell.ContentType.LONG;
        }
        return this;
    }

    @Override
    public Cell setContent(Short value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = Cell.ContentType.LONG;
        }
        return this;
    }

    @Override
    public Cell setContent(Integer value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = Cell.ContentType.LONG;
        }
        return this;
    }

    @Override
    public Cell setContent(Long value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = Cell.ContentType.LONG;
        }
        return this;
    }

    @Override
    public Cell setContent(Float value) {
        if (value == null || Float.isNaN(value.floatValue())) {
            this.setMissing();
        } else {
            this.m_Content = value.floatValue();
            this.m_ContentType = Cell.ContentType.DOUBLE;
        }
        return this;
    }

    @Override
    public Cell setContent(Double value) {
        if (value == null || Double.isNaN(value)) {
            this.setMissing();
        } else {
            this.m_Content = value;
            this.m_ContentType = Cell.ContentType.DOUBLE;
        }
        return this;
    }

    @Override
    public Cell setContent(Date value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.getTime();
            this.m_ContentType = Cell.ContentType.DATE;
        }
        return this;
    }

    @Override
    public Cell setContent(DateTime value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.getTime();
            this.m_ContentType = Cell.ContentType.DATETIME;
        }
        return this;
    }

    @Override
    public Cell setContent(Time value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.getTime();
            this.m_ContentType = Cell.ContentType.TIME;
        }
        return this;
    }

    protected boolean checkFormula(String s) {
        try {
            SpreadSheetFormula.evaluate(s, new HashMap(), this.getSpreadSheet());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected boolean checkBoolean(String s) {
        return (s = s.toLowerCase()).equals("true") || s.equals("false");
    }

    protected boolean checkTime(String s) {
        return DateUtils.checkTime(s, this.getSpreadSheet().getTimeFormat());
    }

    protected boolean checkDate(String s) {
        return DateUtils.checkDate(s, this.getSpreadSheet().getDateFormat());
    }

    protected boolean checkDateTime(String s) {
        return DateUtils.checkDateTime(s, this.getSpreadSheet().getDateTimeFormat());
    }

    protected boolean checkLong(String s) {
        return Utils.isLong(s);
    }

    protected boolean checkDouble(String s) {
        return Utils.isDouble(s, this.getSpreadSheet().getLocale());
    }

    @Override
    public Cell parseContent(String value) {
        if (this.checkBoolean(value)) {
            this.setContent(Boolean.parseBoolean(value));
        } else if (this.checkDateTime(value)) {
            this.setContent(new DateTime(this.getSpreadSheet().getDateTimeFormat().parse(value)));
        } else if (this.checkTime(value)) {
            this.setContent(new Time(this.getSpreadSheet().getTimeFormat().parse(value).getTime()));
        } else if (this.checkDate(value)) {
            this.setContent(this.getSpreadSheet().getDateFormat().parse(value));
        } else if (this.checkLong(value)) {
            this.setContent(new Long(value));
        } else if (this.checkDouble(value)) {
            try {
                this.setContent(Utils.toDouble(value, this.getSpreadSheet().getLocale()));
            }
            catch (Exception e) {
                this.setContentAsString(null);
            }
        } else {
            this.setContentAsString(value);
        }
        return this;
    }

    @Override
    public Cell setContent(String value) {
        if (value == null || value.equals("?")) {
            this.setMissing();
        } else if (value.length() > 0) {
            if (value.startsWith(PREFIX_FORMULA)) {
                if (this.checkFormula(value)) {
                    this.m_Formula = value;
                    this.m_Object = null;
                    this.m_Content = Double.NaN;
                } else {
                    this.m_Formula = null;
                    this.m_Object = null;
                    this.setContentAsString(value);
                }
            } else {
                this.m_Formula = null;
                this.m_Object = null;
                this.parseContent(value);
            }
        } else {
            this.m_Formula = null;
            this.m_Object = null;
            this.setContentAsString(value);
        }
        return this;
    }

    @Override
    public Object parseContent(String value, Cell.ContentType type) {
        switch (type) {
            case BOOLEAN: {
                if (this.checkBoolean(value)) {
                    return Boolean.parseBoolean(value);
                }
                return "?";
            }
            case LONG: {
                if (this.checkLong(value)) {
                    return new Long(value);
                }
                return "?";
            }
            case DOUBLE: {
                if (this.checkDouble(value)) {
                    return new Double(value);
                }
                return "?";
            }
            case STRING: {
                return value;
            }
            case TIME: {
                if (this.checkTime(value)) {
                    return new Time(this.getSpreadSheet().getTimeFormat().parse(value));
                }
                return "?";
            }
            case DATE: {
                if (this.checkDate(value)) {
                    return this.getSpreadSheet().getDateFormat().parse(value);
                }
                return "?";
            }
            case DATETIME: {
                if (this.checkDateTime(value)) {
                    return new DateTime(this.getSpreadSheet().getDateFormat().parse(value));
                }
                return "?";
            }
        }
        return "?";
    }

    @Override
    public Cell setContentAsString(String value) {
        if (value == null || value.equals("?")) {
            this.setMissing();
        } else {
            if (value.equals("'?'")) {
                value = "?";
            }
            this.m_Content = this.getSpreadSheet().getSharedStringsTable().getIndex(value);
            this.m_Object = null;
            this.m_ContentType = Cell.ContentType.STRING;
        }
        return this;
    }

    @Override
    public Cell setObject(Object value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = Double.NaN;
            this.m_Object = value;
            this.m_ContentType = Cell.ContentType.OBJECT;
        }
        return this;
    }

    @Override
    public Cell setFormula(String value) {
        if (value == null || value.equals("?")) {
            this.setMissing();
        } else if (!value.startsWith(PREFIX_FORMULA)) {
            this.setContentAsString(value);
        } else {
            this.m_Formula = value;
            this.m_Object = null;
            this.m_Content = Double.NaN;
        }
        return this;
    }

    @Override
    public String getFormula() {
        return this.m_Formula;
    }

    @Override
    public Object getObject() {
        return this.m_Object;
    }

    @Override
    public String getContent() {
        this.calculateIfRequired();
        switch (this.m_ContentType) {
            case MISSING: {
                return "?";
            }
            case TIME: {
                return this.getSpreadSheet().getTimeFormat().format(new Time((long)this.m_Content));
            }
            case DATE: {
                return this.getSpreadSheet().getDateFormat().format(new Date((long)this.m_Content));
            }
            case DATETIME: {
                return this.getSpreadSheet().getDateTimeFormat().format(new Date((long)this.m_Content));
            }
            case STRING: {
                return this.getSpreadSheet().getSharedStringsTable().getString((int)this.m_Content);
            }
            case LONG: {
                return Long.toString((long)this.m_Content);
            }
            case BOOLEAN: {
                return this.toBoolean().toString();
            }
            case OBJECT: {
                if (this.m_Object == null) {
                    return "?";
                }
                AbstractObjectHandler handler = AbstractObjectHandler.getHandler(this.m_Object);
                if (handler == null) {
                    return "?";
                }
                return handler.format(this.m_Object);
            }
        }
        return Double.toString(this.m_Content);
    }

    @Override
    public Cell.ContentType getContentType() {
        this.calculateIfRequired();
        return this.m_ContentType;
    }

    @Override
    public Cell setNative(Object value) {
        if (value == null) {
            this.setMissing();
        } else if (value instanceof String) {
            this.setContentAsString((String)value);
        } else if (value instanceof Long) {
            this.setContent((Long)value);
        } else if (value instanceof Double) {
            this.setContent((Double)value);
        } else if (value instanceof DateTime) {
            this.setContent((DateTime)value);
        } else if (value instanceof Time) {
            this.setContent((Time)value);
        } else if (value instanceof Date) {
            this.setContent((Date)value);
        } else if (value instanceof Boolean) {
            this.setContent((Boolean)value);
        } else {
            this.setObject(value);
        }
        return this;
    }

    @Override
    public Object getNative() {
        switch (this.m_ContentType) {
            case MISSING: {
                return "?";
            }
            case BOOLEAN: {
                return this.toBoolean();
            }
            case TIME: {
                return this.toTime();
            }
            case DATE: {
                return this.toDate();
            }
            case DATETIME: {
                return this.toDateTime();
            }
            case LONG: {
                return this.toLong();
            }
            case DOUBLE: {
                return this.toDouble();
            }
            case STRING: {
                return this.toString();
            }
            case OBJECT: {
                return this.getObject();
            }
        }
        throw new IllegalStateException("Unhandled content type: " + (Object)((Object)this.m_ContentType));
    }

    @Override
    public int index() {
        return this.getOwner().indexOf(this);
    }

    @Override
    public boolean isNumeric() {
        this.calculateIfRequired();
        return this.m_ContentType == Cell.ContentType.LONG || this.m_ContentType == Cell.ContentType.DOUBLE;
    }

    @Override
    public boolean isMissing() {
        this.calculateIfRequired();
        return this.m_ContentType == Cell.ContentType.MISSING;
    }

    @Override
    public boolean isBoolean() {
        this.calculateIfRequired();
        return this.m_ContentType == Cell.ContentType.BOOLEAN;
    }

    @Override
    public Boolean toBoolean() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.BOOLEAN) {
            return new Boolean(this.m_Content == 1.0);
        }
        return null;
    }

    @Override
    public boolean isAnyDateType() {
        this.calculateIfRequired();
        return this.m_ContentType == Cell.ContentType.TIME || this.m_ContentType == Cell.ContentType.DATE || this.m_ContentType == Cell.ContentType.DATETIME;
    }

    @Override
    public Date toAnyDateType() {
        if (this.isTime()) {
            return this.toTime();
        }
        if (this.isDate()) {
            return this.toDate();
        }
        if (this.isDateTime()) {
            return this.toDateTime();
        }
        return null;
    }

    @Override
    public boolean isDate() {
        this.calculateIfRequired();
        return this.m_ContentType == Cell.ContentType.DATE;
    }

    @Override
    public Date toDate() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.DATE) {
            return new Date((long)this.m_Content);
        }
        return null;
    }

    @Override
    public boolean isDateTime() {
        this.calculateIfRequired();
        return this.m_ContentType == Cell.ContentType.DATETIME;
    }

    @Override
    public DateTime toDateTime() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.DATETIME) {
            return new DateTime((long)this.m_Content);
        }
        return null;
    }

    @Override
    public boolean isTime() {
        this.calculateIfRequired();
        return this.m_ContentType == Cell.ContentType.TIME;
    }

    @Override
    public Time toTime() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.TIME) {
            return new Time((long)this.m_Content);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getContent();
    }

    @Override
    public boolean isDouble() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.DOUBLE) {
            return true;
        }
        if (this.m_ContentType == Cell.ContentType.STRING) {
            return this.checkDouble(this.getContent());
        }
        return false;
    }

    @Override
    public Double toDouble() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.DOUBLE) {
            return this.m_Content;
        }
        if (this.m_ContentType == Cell.ContentType.LONG) {
            return new Double((long)this.m_Content);
        }
        if (this.m_ContentType == Cell.ContentType.STRING) {
            try {
                return Utils.toDouble(this.getContent(), this.getSpreadSheet().getLocale());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isLong() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.LONG) {
            return true;
        }
        if (this.m_ContentType == Cell.ContentType.STRING) {
            return Utils.isLong(this.getContent());
        }
        return false;
    }

    @Override
    public Long toLong() {
        this.calculateIfRequired();
        if (this.m_ContentType == Cell.ContentType.LONG) {
            return (long)this.m_Content;
        }
        if (this.m_ContentType == Cell.ContentType.STRING) {
            return new Double(this.getContent()).longValue();
        }
        return null;
    }

    @Override
    public boolean isFormula() {
        return this.m_Formula != null;
    }

    @Override
    public boolean isObject() {
        return this.m_Object != null;
    }

    @Override
    public void calculate() {
        if (!this.isFormula()) {
            return;
        }
        Object eval = null;
        try {
            eval = SpreadSheetFormula.evaluate(this.getFormula(), new HashMap(), this.getSpreadSheet());
            if (eval instanceof Double && Double.isNaN((Double)eval)) {
                eval = null;
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to parse formula: " + this.getFormula());
            t.printStackTrace();
            eval = FORMULA_ERROR;
        }
        if (eval != null) {
            if (eval instanceof Double) {
                this.setContent((Double)eval);
            } else if (eval instanceof Boolean) {
                this.setContent((Boolean)eval);
            } else {
                this.parseContent("" + eval);
            }
        }
    }

    protected void calculateIfRequired() {
        if (this.isFormula() && Double.isNaN(this.m_Content)) {
            this.calculate();
        }
    }
}

