/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.xhtml;

import adams.doc.xml.AbstractComplexTag;
import adams.doc.xml.AbstractTag;
import adams.doc.xml.DefaultComplexTag;
import adams.doc.xml.DefaultSimpleTag;

public class Table
extends AbstractComplexTag {
    private static final long serialVersionUID = -1301634257381722080L;
    protected int m_NumCols;

    public Table(int numCols) {
        super("table");
        this.m_NumCols = numCols;
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public AbstractComplexTag addRow(String[] cells) {
        return this.addRow(cells, "left", "top");
    }

    public AbstractComplexTag addRow(String[] cells, String align, String valign) {
        if (cells.length != this.m_NumCols) {
            throw new IllegalArgumentException("Number of columns differ (expected/actual): " + this.m_NumCols + " != " + cells.length);
        }
        DefaultComplexTag result = new DefaultComplexTag("tr");
        this.add(result);
        for (String cell : cells) {
            DefaultSimpleTag entry = new DefaultSimpleTag("td", cell);
            entry.setAttribute("align", align);
            entry.setAttribute("valign", valign);
            result.add(entry);
        }
        return result;
    }

    public AbstractComplexTag addRow(AbstractTag[] cells) {
        return this.addRow(cells, "left", "top");
    }

    public AbstractComplexTag addRow(AbstractTag[] cells, String align, String valign) {
        if (cells.length != this.m_NumCols) {
            throw new IllegalArgumentException("Number of columns differ (expected/actual): " + this.m_NumCols + " != " + cells.length);
        }
        DefaultComplexTag result = new DefaultComplexTag("tr");
        this.add(result);
        for (AbstractTag cell : cells) {
            DefaultComplexTag entry = new DefaultComplexTag("td");
            entry.setAttribute("align", align);
            entry.setAttribute("valign", valign);
            entry.add(cell);
            result.add(entry);
        }
        return result;
    }
}

