/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.AutomatableInteraction;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.gui.core.GUIHelper;

public class PromptUser
extends AbstractBooleanCondition
implements AutomatableInteraction {
    private static final long serialVersionUID = 3278345095591806425L;
    public static final String PLACEHOLDER_SHORT = "{SHORT}";
    public static final String PLACEHOLDER_FULL = "{FULL}";
    protected String m_Message;
    protected String m_CaptionPositive;
    protected String m_CaptionNegative;
    protected String m_InitialSelection;
    protected boolean m_NonInteractive;
    protected GUIHelper.DialogCommunication m_Communication;

    @Override
    public String globalInfo() {
        return "Prompts the user to click on 'positive' or 'negative' button.\nThe actor's name can be used in the message using the following placeholders:\n{SHORT} - the short name\n{FULL} - the full name (incl path)";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", "Do you want to execute {SHORT}?");
        this.m_OptionManager.add("caption-positive", "captionPositive", "yes");
        this.m_OptionManager.add("caption-negative", "captionNegative", "no");
        this.m_OptionManager.add("initial-selection", "initialSelection", "");
        this.m_OptionManager.add("non-interactive", "nonInteractive", false);
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to prompt the user with.";
    }

    public void setCaptionPositive(String value) {
        this.m_CaptionPositive = value;
        this.reset();
    }

    public String getCaptionPositive() {
        return this.m_CaptionPositive;
    }

    public String captionPositiveTipText() {
        return "The caption for the 'positive' button.";
    }

    public void setCaptionNegative(String value) {
        this.m_CaptionNegative = value;
        this.reset();
    }

    public String getCaptionNegative() {
        return this.m_CaptionNegative;
    }

    public String captionNegativeTipText() {
        return "The caption for the 'negative' button.";
    }

    @Override
    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    public void setInitialSelection(String value) {
        this.m_InitialSelection = value;
        this.reset();
    }

    public String getInitialSelection() {
        return this.m_InitialSelection;
    }

    public String initialSelectionTipText() {
        return "The initial selection to prompt the user with.";
    }

    @Override
    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    @Override
    public String nonInteractiveTipText() {
        return "If enabled, the condition automatically evaluates to the button that matches the initial selection or, if that is left empty, to 'true'.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "message", this.m_Message, "message: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        String answer;
        String initial;
        String message = this.m_Message;
        if (owner != null) {
            message = message.replace(PLACEHOLDER_SHORT, owner.getName()).replace(PLACEHOLDER_FULL, owner.getFullName());
        }
        String string = initial = this.m_InitialSelection.isEmpty() ? this.m_CaptionPositive : this.m_InitialSelection;
        if (!this.m_NonInteractive) {
            this.m_Communication = new GUIHelper.DialogCommunication();
            answer = GUIHelper.showInputDialog(owner == null ? null : owner.getParentComponent(), message, initial, new String[]{this.m_CaptionPositive, this.m_CaptionNegative}, false, "Please choose", this.m_Communication);
            this.m_Communication = null;
        } else {
            answer = initial;
        }
        return answer != null && answer.equals(this.m_CaptionPositive);
    }

    @Override
    public void stopExecution() {
        if (this.m_Communication != null) {
            this.m_Communication.requestClose();
        }
    }
}

