/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Utils;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;

public abstract class AbstractConnectedControlActor
extends AbstractDirectedControlActor {
    private static final long serialVersionUID = 5833691705690296758L;

    protected String classesToString(Class[] classes) {
        return "[" + Utils.classesToString(classes) + "]";
    }

    protected String checkConnections() {
        String result = null;
        AbstractActor curr = null;
        AbstractActor prev = null;
        ActorHandlerInfo info = this.getActorHandlerInfo();
        boolean standalones = info.canContainStandalones();
        for (int i = 0; i < this.size(); ++i) {
            if (curr != null && !curr.getSkip()) {
                prev = curr;
            }
            if ((curr = this.get(i)).getSkip()) continue;
            if (this.isLoggingEnabled()) {
                this.getLogger().fine(this.getFullName() + ".checkConnections/" + i + ": curr=" + curr.getFullName() + ", prev=" + (prev == null ? "-null-" : prev.getFullName()));
            }
            if (standalones) {
                if (curr instanceof InputConsumer || curr instanceof OutputProducer) {
                    standalones = false;
                    if (curr instanceof OutputProducer || i >= this.size() - 1) continue;
                    result = "First non-standalone actor has to be a '" + OutputProducer.class.getName() + "'. " + "'" + curr.getFullName() + "' isn't one!";
                    break;
                }
            } else if (!(curr instanceof InputConsumer) && !(curr instanceof OutputProducer)) {
                if (info.canContainStandalones()) {
                    result = "The standalone '" + curr.getFullName() + "' " + "has to be listed before all other types of actors!";
                    break;
                }
                result = "No standalones allowed!";
                break;
            }
            if (prev == null || standalones) continue;
            if (prev instanceof OutputProducer && curr instanceof InputConsumer) {
                if (this.m_Compatibility.isCompatible((OutputProducer)((Object)prev), (InputConsumer)((Object)curr))) continue;
                result = "Actor '" + prev.getFullName() + "' " + "outputs '" + this.classesToString(((OutputProducer)((Object)prev)).generates()) + "',\n" + "but actor '" + curr.getFullName() + "' " + "only accepts '" + this.classesToString(((InputConsumer)((Object)curr)).accepts()) + "'!";
                break;
            }
            if (!(prev instanceof OutputProducer)) {
                result = "Actor '" + prev.getFullName() + "' does not generate any output!";
                break;
            }
            if (curr instanceof InputConsumer) continue;
            result = "Actor '" + curr.getFullName() + "' does not accept any input!";
            break;
        }
        return result;
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null) {
            result = this.checkConnections();
        }
        return result;
    }
}

