/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseClassname;
import adams.core.option.OptionHandler;
import adams.flow.control.Branch;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.lang.reflect.Array;
import java.util.Hashtable;

public class ArrayGenerate
extends Branch
implements OutputProducer {
    private static final long serialVersionUID = 5975989766824652946L;
    public static final String BACKUP_OUTPUT = "output";
    protected BaseClassname m_ArrayClass;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Applies all sub-actors to the input token and generates an array from the collected output.\nEach of the branches is expected to produce at most one output token (ideally one per branch, otherwise there will be null elements in the output array).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("array-class", "arrayClass", new BaseClassname());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "arrayClass", this.m_ArrayClass.length() != 0 ? this.m_ArrayClass : "-from 1st element-", "Class: ");
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setCollectOutput(true);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public void setArrayClass(BaseClassname value) {
        this.m_ArrayClass = value;
        this.reset();
    }

    public BaseClassname getArrayClass() {
        return this.m_ArrayClass;
    }

    public String arrayClassTipText() {
        return "The class to use for the array; if none is specified, the class of the first element is used.";
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_OutputToken != null) {
            result.put(BACKUP_OUTPUT, this.m_OutputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_OUTPUT)) {
            this.m_OutputToken = (Token)state.get(BACKUP_OUTPUT);
            state.remove(BACKUP_OUTPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] generates() {
        Class[] result;
        if (this.m_ArrayClass.length() > 0) {
            try {
                result = new Class[]{Utils.newArray(this.m_ArrayClass.getValue(), 0).getClass()};
            }
            catch (Exception e) {
                result = new Class[]{};
            }
        } else if (this.active() > 0) {
            Class[] sub = ((OutputProducer)((Object)this.firstActive())).generates();
            result = new Class[sub.length];
            for (int i = 0; i < sub.length; ++i) {
                result[i] = Array.newInstance(sub[i], 0).getClass();
            }
        } else {
            result = new Class[]{Unknown.class};
        }
        return result;
    }

    @Override
    protected String checkBranch(AbstractActor branch) {
        String result = super.checkBranch(branch);
        if (result == null && !ActorUtils.isTransformer(branch)) {
            result = "'" + branch.getFullName() + "' is not a transformer!";
        }
        return result;
    }

    @Override
    public void input(Token token) {
        super.input(token);
        this.m_OutputToken = null;
    }

    @Override
    protected String doExecute() {
        String result = super.doExecute();
        if (!this.isStopped() && this.m_CollectedOutput.size() > 0) {
            Object output = this.m_ArrayClass.length() == 0 ? Array.newInstance(((Token)this.m_CollectedOutput.get(0)).getPayload().getClass(), this.size()) : Utils.newArray(this.m_ArrayClass.getValue(), this.size());
            for (int i = 0; i < this.size(); ++i) {
                if (!this.m_CollectedOutput.containsKey(i)) continue;
                Array.set(output, i, ((Token)this.m_CollectedOutput.get(i)).getPayload());
            }
            this.m_OutputToken = new Token(output);
        }
        return result;
    }

    @Override
    protected String postExecute() {
        String result = super.postExecute();
        if (this.isStopped()) {
            this.m_OutputToken = null;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

