/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.AbstractContainer;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.AbstractContainerUpdater;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;

public class PlotContainerUpdater
extends AbstractContainerUpdater {
    private static final long serialVersionUID = 7140175689043000123L;
    protected PlotContainerValue m_ContainerValue;
    protected String m_MetaDataKey;

    @Override
    public String globalInfo() {
        return "Applies all sub-actors to process either the selected value of the plot container.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("container-value", "containerValue", (Object)PlotContainerValue.Y_VALUE);
        this.m_OptionManager.add("meta-data-key", "metaDataKey", "");
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "containerValue", (Object)this.m_ContainerValue);
        String value = QuickInfoHelper.toString((OptionHandler)this, "metaDataKey", this.m_MetaDataKey, ", meta-data: ");
        if (value != null) {
            result = result + value;
        }
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    public void setContainerValue(PlotContainerValue value) {
        switch (value) {
            case PLOT_NAME: {
                this.setContainerValueName("PlotName");
                break;
            }
            case X_VALUE: {
                this.setContainerValueName("X");
                break;
            }
            case Y_VALUE: {
                this.setContainerValueName("Y");
                break;
            }
            case X_ERROR_VALUE: {
                this.setContainerValueName("Error X");
                break;
            }
            case Y_ERROR_VALUE: {
                this.setContainerValueName("Error Y");
                break;
            }
            case META_DATA: {
                this.setContainerValueName("MetaData");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled container value: " + (Object)((Object)value));
            }
        }
        this.m_ContainerValue = value;
        this.reset();
    }

    public PlotContainerValue getContainerValue() {
        return this.m_ContainerValue;
    }

    public String containerValueTipText() {
        return "The type of value to update.";
    }

    public void setMetaDataKey(String value) {
        this.m_MetaDataKey = value;
        this.reset();
    }

    public String getMetaDataKey() {
        return this.m_MetaDataKey;
    }

    public String metaDataKeyTipText() {
        return "The key to use when updating meta-data.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            Class[] cls;
            switch (this.m_ContainerValue) {
                case PLOT_NAME: {
                    cls = new Class[]{String.class};
                    break;
                }
                case X_ERROR_VALUE: 
                case Y_ERROR_VALUE: {
                    cls = new Class[]{Object[].class};
                    break;
                }
                case X_VALUE: 
                case Y_VALUE: {
                    cls = new Class[]{Object.class};
                    break;
                }
                case META_DATA: {
                    cls = new Class[]{Object.class};
                    break;
                }
                default: {
                    cls = null;
                    result = "Unhandled container value: " + (Object)((Object)this.m_ContainerValue);
                }
            }
            if (result == null) {
                Compatibility comp = new Compatibility();
                if (!comp.isCompatible(((InputConsumer)((Object)this.firstActive())).accepts(), cls)) {
                    result = "First active sub-actor does not accept " + cls[0].getName();
                } else if (!comp.isCompatible(((OutputProducer)((Object)this.lastActive())).generates(), cls)) {
                    result = "Last active sub-actor does not generate " + cls[0].getName();
                }
            }
        }
        return result;
    }

    @Override
    protected Object getContainerValue(AbstractContainer cont) {
        if (this.m_ContainerValue == PlotContainerValue.META_DATA) {
            SequencePlotterContainer plotcont = (SequencePlotterContainer)cont;
            if (plotcont.getMetaData().containsKey(this.m_MetaDataKey)) {
                return plotcont.getMetaData().get(this.m_MetaDataKey);
            }
            throw new IllegalStateException("Meta-data value not present: " + this.m_MetaDataKey);
        }
        return super.getContainerValue(cont);
    }

    public static enum PlotContainerValue {
        PLOT_NAME,
        X_VALUE,
        Y_VALUE,
        X_ERROR_VALUE,
        Y_ERROR_VALUE,
        META_DATA;

    }
}

