/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Properties;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.db.LogEntry;
import adams.flow.core.AbstractActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import java.util.ArrayList;

public class StorageQueueHandler
extends LoggingObject {
    private static final long serialVersionUID = 5211228304482833329L;
    protected String m_Name;
    protected ArrayList m_Queue;
    protected int m_Limit;
    protected AbstractActor m_Logging;
    protected AbstractActor m_Monitoring;

    public StorageQueueHandler(String name) {
        this(name, -1, null, null);
    }

    public StorageQueueHandler(String name, int limit, AbstractActor logging, AbstractActor monitoring) {
        if (limit <= 0) {
            limit = -1;
        }
        this.m_Name = name;
        this.m_Queue = new ArrayList();
        this.m_Limit = limit;
        this.m_Logging = logging;
        this.m_Monitoring = monitoring;
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.m_Logger = null;
    }

    public String getname() {
        return this.m_Name;
    }

    public int getLimit() {
        return this.m_Limit;
    }

    public boolean hasLogging() {
        return this.m_Logging != null;
    }

    public AbstractActor getLogging() {
        return this.m_Logging;
    }

    public boolean hasMonitoring() {
        return this.m_Monitoring != null;
    }

    public AbstractActor getMonitoring() {
        return this.m_Monitoring;
    }

    protected void log(LogEntry log, AbstractActor actor) {
        if (actor instanceof InputConsumer) {
            ((InputConsumer)((Object)actor)).input(new Token(log));
            actor.execute();
        }
    }

    protected void logError(String msg, Object obj) {
        Properties props = new Properties();
        props.setProperty("Errors", msg);
        if (obj != null) {
            props.setProperty("Object", "" + obj);
        }
        LogEntry log = new LogEntry();
        log.setType("StorageQueueError");
        log.setSource(this.m_Name);
        log.setStatus("New");
        log.setMessage(props);
        this.log(log, this.m_Logging);
    }

    protected void logMonitor(String type, Object obj) {
        Properties props = new Properties();
        if (obj != null) {
            props.setProperty("Object", "" + obj);
        }
        LogEntry log = new LogEntry();
        log.setType("StorageQueue" + type);
        log.setSource(this.m_Name);
        log.setStatus("New");
        log.setMessage(props);
        this.log(log, this.m_Monitoring);
    }

    public synchronized boolean add(Object obj) {
        if (this.m_Limit == -1) {
            this.m_Queue.add(obj);
            if (this.hasMonitoring()) {
                this.logMonitor("Add", obj);
            }
            return true;
        }
        if (this.m_Queue.size() + 1 <= this.m_Limit) {
            this.m_Queue.add(obj);
            if (this.hasMonitoring()) {
                this.logMonitor("Add", obj);
            }
            return true;
        }
        if (this.hasLogging()) {
            this.logError("Cannot add item to queue '" + this.m_Name + "' as it reached its limit: " + this.m_Limit, obj);
        }
        return false;
    }

    public synchronized Object remove() {
        Object result = this.m_Queue.remove(0);
        if (this.hasMonitoring()) {
            this.logMonitor("Remove", result);
        }
        return result;
    }

    public synchronized int size() {
        return this.m_Queue.size();
    }

    public String toString() {
        return "name=" + this.m_Name + ", size=" + this.m_Queue.size() + ", limit=" + this.m_Limit + ", logging=" + this.m_Logging + ", monitoring=" + this.m_Monitoring;
    }
}

