/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.control.ConditionalSubProcess;
import adams.flow.control.Sequence;
import adams.flow.control.SequentialDirector;
import adams.flow.control.TimedSubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorWithConditionalEquivalent;
import adams.flow.core.ActorWithTimedEquivalent;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.PauseStateHandler;
import adams.flow.core.PauseStateManager;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.ArrayList;
import java.util.List;

public class SubProcess
extends Sequence
implements OutputProducer,
PauseStateHandler,
ActorWithConditionalEquivalent,
ActorWithTimedEquivalent {
    private static final long serialVersionUID = 7433940498896052594L;
    protected transient List<Token> m_OutputTokens;
    protected boolean m_AllowEmpty;

    @Override
    public String globalInfo() {
        return "Encapsulates a sequence of flow items. The first actor must accept input and the last one must produce output.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_AllowEmpty = false;
    }

    @Override
    public Class getConditionalEquivalent() {
        return ConditionalSubProcess.class;
    }

    @Override
    public Class getTimedEquivalent() {
        return TimedSubProcess.class;
    }

    protected List<Token> getOutputTokens() {
        if (this.m_OutputTokens == null) {
            this.m_OutputTokens = new ArrayList<Token>();
        }
        return this.m_OutputTokens;
    }

    @Override
    protected SequentialDirector newDirector() {
        return new SubProcessDirector();
    }

    @Override
    public PauseStateManager getPauseStateManager() {
        return this.m_PauseStateManager;
    }

    public void setAllowEmpty(boolean value) {
        this.m_AllowEmpty = value;
    }

    public boolean getAllowEmpty() {
        return this.m_AllowEmpty;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (this.m_PauseStateManager == null) {
            this.m_PauseStateManager = new PauseStateManager();
        }
        if (!this.m_AllowEmpty && result == null) {
            if (this.active() == 0) {
                result = "No active (= non-skipped) actors!";
            }
            if (result == null) {
                if (!(this.firstActive() instanceof InputConsumer)) {
                    result = "First actor ('" + this.firstActive().getName() + "') does not accept input!";
                } else if (!(this.lastActive() instanceof OutputProducer)) {
                    result = "Last actor ('" + this.lastActive().getName() + "') does not generate output!";
                }
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.active() > 0) {
            return ((InputConsumer)((Object)this.firstActive())).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        if (this.active() > 0) {
            return ((OutputProducer)((Object)this.lastActive())).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        super.input(token);
        if (this.m_OutputTokens != null) {
            this.m_OutputTokens.clear();
        }
    }

    protected void addOutputToken(Token output) {
        this.getOutputTokens().add(output);
    }

    @Override
    public String execute() {
        if (this.m_OutputTokens != null) {
            this.m_OutputTokens.clear();
        }
        String result = super.execute();
        if (this.m_Skip) {
            this.getOutputTokens().add(this.m_CurrentToken);
        }
        return result;
    }

    @Override
    public Token output() {
        Token result;
        if (this.getOutputTokens().size() > 0) {
            result = this.getOutputTokens().get(0);
            this.getOutputTokens().remove(0);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.getOutputTokens().size() > 0;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_OutputTokens != null) {
            this.m_OutputTokens.clear();
        }
    }

    public static class SubProcessDirector
    extends SequentialDirector {
        private static final long serialVersionUID = 1600945233224761728L;

        public void setControlActor(AbstractDirectedControlActor value) {
            if (value instanceof SubProcess || value == null) {
                super.setControlActor(value);
            } else {
                System.err.println("Group must be a SubProcess actor (provided: " + (value != null ? value.getClass().getName() : "-null-") + ")!");
            }
        }

        @Override
        protected boolean isFinalOutputRecorded() {
            return true;
        }

        @Override
        protected String doExecuteActors(AbstractActor startActor) {
            String result = super.doExecuteActors(startActor);
            if (result == null) {
                for (int i = 0; i < this.m_FinalOutput.size(); ++i) {
                    ((SubProcess)this.getControlActor()).addOutputToken((Token)this.m_FinalOutput.get(i));
                }
            }
            return result;
        }
    }
}

