/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.logging.LoggingLevel;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Expression;
import adams.flow.control.AbstractControlActor;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class WhileLoop
extends AbstractControlActor
implements InputConsumer,
MutableActorHandler,
BooleanConditionSupporter {
    private static final long serialVersionUID = -2837014912083918343L;
    protected BooleanCondition m_Condition;
    protected Sequence m_Actors;

    @Override
    public String globalInfo() {
        return "Emulates a while-loop. The sub-actor gets executed as long as the condition evaluates to 'true'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", new Expression());
        this.m_OptionManager.add("loop", "actors", new AbstractActor[0]);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setAllowSource(true);
    }

    @Override
    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition to evaluate - only as long as it evaluates to 'true' the loop actors get executed.";
    }

    public void setActors(AbstractActor[] value) {
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to execute in the loop.";
    }

    @Override
    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    @Override
    public String getQuickInfo() {
        return this.m_Condition.getQuickInfo();
    }

    @Override
    public int size() {
        return this.m_Actors.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    @Override
    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    @Override
    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected String setUpLoopActors() {
        String result = ActorUtils.checkForSource(this.getActors());
        if (result == null) {
            result = this.m_Actors.setUp();
        }
        return result;
    }

    @Override
    protected String setUpSubActors() {
        String result = null;
        if (this.m_Actors.size() == 0) {
            result = "No loop-actors provided!";
        }
        if (result == null && !this.getSkip()) {
            this.updateParent();
            result = this.setUpLoopActors();
        }
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Condition == null) {
            result = "No condition provided!";
        }
        if (result == null) {
            result = this.m_Condition.setUp(this);
        }
        return result;
    }

    @Override
    public void input(Token token) {
    }

    @Override
    public boolean hasInput() {
        return false;
    }

    @Override
    public Token currentInput() {
        return null;
    }

    protected boolean doLoop() {
        return this.m_Condition.evaluate(this, null);
    }

    @Override
    protected String doExecute() {
        String result = null;
        while (this.doLoop() && result == null && !this.isStopped()) {
            try {
                result = this.m_Actors.execute();
            }
            catch (Exception e) {
                result = this.handleException(this.m_Actors.getFullName() + " generated following exception: ", e);
            }
            if (result != null || this.isStopped()) continue;
            result = this.preExecute();
        }
        if (result != null) {
            result = this.m_Actors.getErrorHandler().handleError(this.m_Actors, "execute", result);
        }
        return result;
    }

    @Override
    public void flushExecution() {
        this.m_Actors.flushExecution();
    }

    @Override
    public void stopExecution() {
        this.m_Actors.stopExecution();
        this.m_Condition.stopExecution();
        super.stopExecution();
    }
}

