/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.plotprocessor;

import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.plotprocessor.AbstractPlotProcessor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class LOWESS
extends AbstractPlotProcessor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5171916489269022308L;
    protected int m_WindowSize;
    protected List<Point2D> m_Data;

    @Override
    public String globalInfo() {
        return "A processor that applies LOWESS smoothing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Data = new ArrayList<Point2D>();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Data.clear();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return adams.data.utils.LOWESS.getTechnicalInformation();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", 20, 1, null);
    }

    public void setWindowSize(int value) {
        if (value >= 1) {
            this.m_WindowSize = value;
            this.reset();
        } else {
            this.getLogger().severe("The window size must be at least 1 (provided: " + value + ")!");
        }
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The window size to use, must be at least 20.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "windowSize", this.m_WindowSize, ", window: ");
        return result;
    }

    @Override
    protected List<SequencePlotterContainer> doProcess(SequencePlotterContainer cont) {
        ArrayList<SequencePlotterContainer> result = null;
        Comparable x = (Comparable)cont.getValue("X");
        Comparable y = (Comparable)cont.getValue("Y");
        if (x instanceof Number && y instanceof Number) {
            Point2D point = new Point2D.Double(((Number)((Object)x)).doubleValue(), ((Number)((Object)y)).doubleValue());
            this.m_Data.add(point);
            while (this.m_Data.size() > this.m_WindowSize) {
                this.m_Data.remove(0);
            }
            if (this.m_Data.size() == this.m_WindowSize) {
                List<Point2D> smoothed = adams.data.utils.LOWESS.calculate(this.m_Data, this.m_WindowSize);
                if (smoothed.size() > 0) {
                    point = smoothed.get(smoothed.size() / 2);
                    result = new ArrayList<SequencePlotterContainer>();
                    result.add(new SequencePlotterContainer(this.getPlotName(cont), Double.valueOf(point.getX()), Double.valueOf(point.getY()), this.getPlotType()));
                } else {
                    this.m_LastError = "Expected at least one smoothed point, encountered none!";
                }
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Data.clear();
    }
}

