/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Utils;
import adams.flow.core.ActorExecution;
import java.io.Serializable;

public class ActorHandlerInfo
implements Serializable {
    private static final long serialVersionUID = -6507471599929125550L;
    protected boolean m_CanContainStandalones;
    protected boolean m_CanContainSource;
    protected boolean m_CanEncloseActors;
    protected ActorExecution m_ActorExecution;
    protected boolean m_ForwardsInput;
    protected Class[] m_Restrictions;

    public ActorHandlerInfo(boolean canContainStandalones, ActorExecution actorExecution, boolean forwardsInput) {
        this(canContainStandalones, true, actorExecution, forwardsInput);
    }

    public ActorHandlerInfo(boolean canContainStandalones, boolean canContainSource, ActorExecution actorExecution, boolean forwardsInput) {
        this(canContainStandalones, canContainSource, actorExecution, forwardsInput, null);
    }

    public ActorHandlerInfo(boolean canContainStandalones, boolean canContainSource, ActorExecution actorExecution, boolean forwardsInput, Class[] restrictions) {
        this(canContainStandalones, canContainSource, actorExecution, forwardsInput, restrictions, true);
    }

    public ActorHandlerInfo(boolean canContainStandalones, boolean canContainSource, ActorExecution actorExecution, boolean forwardsInput, Class[] restrictions, boolean canEncloseActors) {
        this.m_CanContainStandalones = canContainStandalones;
        this.m_CanContainSource = canContainSource;
        this.m_CanEncloseActors = canEncloseActors;
        this.m_ActorExecution = actorExecution;
        this.m_ForwardsInput = forwardsInput;
        this.m_Restrictions = restrictions == null ? new Class[0] : (Class[])restrictions.clone();
    }

    public boolean canContainStandalones() {
        return this.m_CanContainStandalones;
    }

    public boolean canContainSource() {
        return this.m_CanContainSource;
    }

    public boolean canEncloseActors() {
        return this.m_CanEncloseActors;
    }

    public ActorExecution getActorExecution() {
        return this.m_ActorExecution;
    }

    public boolean getForwardsInput() {
        return this.m_ForwardsInput;
    }

    public boolean hasRestrictions() {
        return this.m_Restrictions.length > 0;
    }

    public Class[] getRestrictions() {
        return this.m_Restrictions;
    }

    public String toString() {
        return "standalones=" + this.m_CanContainStandalones + ", " + "execution=" + (Object)((Object)this.m_ActorExecution) + ", " + "forwardsInput=" + this.m_ForwardsInput + ", " + "restrictions=" + Utils.arrayToString(this.m_Restrictions);
    }
}

