/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ClassLister;
import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ActorUsage
extends AbstractOptionHandler {
    private static final long serialVersionUID = 6655416366310701302L;
    protected PlaceholderDirectory[] m_Directories;
    protected boolean m_Recursive;
    protected boolean m_NoPath;
    protected SpreadSheetWriter m_Writer;
    protected PlaceholderFile m_Output;

    @Override
    public String globalInfo() {
        return "Traverses directories and loads all flows that it can locate for examination. Generates a spreadsheet containing two columns:\n1. actor class\n2. all flow files that use this actor";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir", "directories", new PlaceholderDirectory[0]);
        this.m_OptionManager.add("recursive", "recursive", false);
        this.m_OptionManager.add("no-path", "noPath", false);
        this.m_OptionManager.add("writer", "writer", this.getDefaultWriter());
        this.m_OptionManager.add("output", "output", new PlaceholderFile("."));
    }

    public void setDirectories(PlaceholderDirectory[] value) {
        this.m_Directories = value;
        this.reset();
    }

    public PlaceholderDirectory[] getDirectories() {
        return this.m_Directories;
    }

    public String directoriesTipText() {
        return "The directories to traverse.";
    }

    public void setRecursive(boolean value) {
        this.m_Recursive = value;
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Recursive;
    }

    public String recursiveTipText() {
        return "If enabled, the directories are traversed recursively.";
    }

    public void setNoPath(boolean value) {
        this.m_NoPath = value;
        this.reset();
    }

    public boolean getNoPath() {
        return this.m_NoPath;
    }

    public String noPathTipText() {
        return "If enabled, the path is omitted in the generated spreadsheet.";
    }

    protected SpreadSheetWriter getDefaultWriter() {
        return new CsvSpreadSheetWriter();
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer for storing the spreadsheet.";
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The file to write the spreadsheet to with the specified writer, ignored if pointing to a directory.";
    }

    protected List<String> locateFlows() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.m_Directories.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Traversing '" + this.m_Directories[i] + "' (recursive=" + this.m_Recursive + ")...");
            }
            DirectoryLister lister = new DirectoryLister();
            lister.setListFiles(true);
            lister.setRegExp(new BaseRegExp(".*\\.flow"));
            lister.setRecursive(this.m_Recursive);
            lister.setWatchDir(this.m_Directories[i]);
            result.addAll(Arrays.asList(lister.list()));
        }
        return result;
    }

    protected SpreadSheet analyzeFlows(List<String> flows) {
        List list;
        HashMap relation = new HashMap();
        String[] names = ClassLister.getSingleton().getClassnames(AbstractActor.class);
        for (String string : names) {
            relation.put(string, new ArrayList());
        }
        int count = 0;
        for (String flow : flows) {
            ++count;
            String flowAct = this.m_NoPath ? new PlaceholderFile(flow).getName() : flow;
            AbstractActor actor = ActorUtils.read(flow);
            if (actor == null) {
                this.getLogger().warning("Failed to read: " + flow);
            } else {
                List<AbstractActor> actors = ActorUtils.enumerate(actor);
                for (int i = 0; i < actors.size(); ++i) {
                    list = (List)relation.get(actors.get(i).getClass().getName());
                    if (list.contains(flowAct)) continue;
                    list.add(flowAct);
                }
            }
            if (!this.isLoggingEnabled() || count % 100 != 0) continue;
            this.getLogger().info("Analyzing flows " + count + "/" + flows.size() + "...");
        }
        for (String string : names) {
            Collections.sort((List)relation.get(string));
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Generating spreadsheet...");
        }
        SpreadSheet result = new SpreadSheet();
        Row row = result.getHeaderRow();
        row.addCell("C").setContent("Class");
        row.addCell("F").setContent("Flow");
        for (String string : names) {
            list = (List)relation.get(string);
            if (list.size() == 0) {
                row = result.addRow();
                row.addCell("C").setContent(string);
                row.addCell("F").setContent("");
                continue;
            }
            for (String flow : list) {
                row = result.addRow();
                row.addCell("C").setContent(string);
                row.addCell("F").setContent(flow);
            }
        }
        return result;
    }

    public SpreadSheet execute() {
        List<String> flows = this.locateFlows();
        SpreadSheet result = this.analyzeFlows(flows);
        if (result == null) {
            this.getLogger().severe("Failed to generate spreadsheet!");
        } else if (!this.m_Output.isDirectory()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Writing spreadsheet to " + this.m_Output + "...");
            }
            if (!this.m_Writer.write(result, this.m_Output)) {
                this.getLogger().severe("Failed to write spreadsheet to: " + this.m_Output);
            } else {
                this.getLogger().info("Finished writing spreadsheet!");
            }
        } else if (this.isLoggingEnabled()) {
            this.getLogger().info("No output file provided, not writing spreadsheet to disk.");
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (OptionUtils.helpRequested(args)) {
            System.out.println();
            System.out.println("Usage: " + ActorUsage.class.getName() + " [-env <classname>] [-dir <flow dir> ...] [-recursive] [-no-path] [-writer <classname + options>] [-output <file>]");
            System.out.println();
            return;
        }
        String env = OptionUtils.removeOption(args, "-env");
        if (env == null) {
            env = Environment.class.getName();
        }
        Class<?> cls = Class.forName(env);
        Environment.setEnvironmentClass(cls);
        ActorUsage usage = (ActorUsage)OptionUtils.forName(ActorUsage.class, ActorUsage.class.getName(), args);
        if (usage.execute() == null) {
            System.err.println("Failed to generate spreadsheet!");
        }
    }
}

