/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.core.Variables;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.debug.View;
import adams.gui.tools.ExpressionWatchPanel;

public abstract class AbstractBreakpoint
extends AbstractOptionHandler {
    private static final long serialVersionUID = 4654096855875796107L;
    protected boolean m_Disabled;
    protected boolean m_OnPreInput;
    protected boolean m_OnPostInput;
    protected boolean m_OnPreExecute;
    protected boolean m_OnPostExecute;
    protected boolean m_OnPreOutput;
    protected boolean m_OnPostOutput;
    protected View[] m_Views;
    protected BaseString[] m_Watches;
    protected ExpressionWatchPanel.ExpressionType[] m_WatchTypes;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("disabled", "disabled", false);
        this.m_OptionManager.add("on-pre-input", "onPreInput", false);
        this.m_OptionManager.add("on-post-input", "onPostInput", false);
        this.m_OptionManager.add("on-pre-execute", "onPreExecute", false);
        this.m_OptionManager.add("on-post-execute", "onPostExecute", false);
        this.m_OptionManager.add("on-pre-output", "onPreOutput", false);
        this.m_OptionManager.add("on-post-output", "onPostOutput", false);
        this.m_OptionManager.add("watch", "watches", new BaseString[0]);
        this.m_OptionManager.add("watch-type", "watchTypes", new ExpressionWatchPanel.ExpressionType[0]);
        this.m_OptionManager.add("view", "views", new View[0]);
    }

    public void setDisabled(boolean value) {
        this.m_Disabled = value;
        this.reset();
    }

    public boolean getDisabled() {
        return this.m_Disabled;
    }

    public String disabledTipText() {
        return "If set to true, the breakpoint is completely disabled.";
    }

    public void setOnPreInput(boolean value) {
        this.m_OnPreInput = value;
        this.reset();
    }

    public boolean getOnPreInput() {
        return this.m_OnPreInput;
    }

    public String onPreInputTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-input (of token) time; token available.";
    }

    public void setOnPostInput(boolean value) {
        this.m_OnPostInput = value;
        this.reset();
    }

    public boolean getOnPostInput() {
        return this.m_OnPostInput;
    }

    public String onPostInputTipText() {
        return "If set to true, the breakpoint gets evaluated at post-input (of token) time.";
    }

    public void setOnPreExecute(boolean value) {
        this.m_OnPreExecute = value;
        this.reset();
    }

    public boolean getOnPreExecute() {
        return this.m_OnPreExecute;
    }

    public String onPreExecuteTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-execute time.";
    }

    public void setOnPostExecute(boolean value) {
        this.m_OnPostExecute = value;
        this.reset();
    }

    public boolean getOnPostExecute() {
        return this.m_OnPostExecute;
    }

    public String onPostExecuteTipText() {
        return "If set to true, the breakpoint gets evaluated at post-execute time.";
    }

    public void setOnPreOutput(boolean value) {
        this.m_OnPreOutput = value;
        this.reset();
    }

    public boolean getOnPreOutput() {
        return this.m_OnPreOutput;
    }

    public String onPreOutputTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-output (of token) time; token available.";
    }

    public void setOnPostOutput(boolean value) {
        this.m_OnPostOutput = value;
        this.reset();
    }

    public boolean getOnPostOutput() {
        return this.m_OnPostOutput;
    }

    public String onPostOutputTipText() {
        return "If set to true, the breakpoint gets evaluated at post-output (of token) time.";
    }

    public void setWatches(BaseString[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (!Variables.isPlaceholder(value[i].getValue())) continue;
            value[i] = new BaseString("(" + value[i].getValue() + ")");
        }
        this.m_Watches = value;
        this.reset();
    }

    public BaseString[] getWatches() {
        return this.m_Watches;
    }

    public String watchesTipText() {
        return "The expression to display initially in the watch dialog; the type of the watch needs to be specified as well.";
    }

    public void setWatchTypes(ExpressionWatchPanel.ExpressionType[] value) {
        this.m_WatchTypes = value;
        this.reset();
    }

    public ExpressionWatchPanel.ExpressionType[] getWatchTypes() {
        return this.m_WatchTypes;
    }

    public String watchTypesTipText() {
        return "The types of the watch expressions; determines how the expressions get evaluated and displayed.";
    }

    public void setViews(View[] value) {
        this.m_Views = value;
        this.reset();
    }

    public View[] getViews() {
        return this.m_Views;
    }

    public String viewsTipText() {
        return "The views to display automatically when the breakpoint is reached.";
    }

    protected abstract boolean evaluatePreInput(Actor var1, Token var2);

    protected abstract boolean evaluatePostInput(Actor var1);

    protected abstract boolean evaluatePreExecute(Actor var1);

    protected abstract boolean evaluatePostExecute(Actor var1);

    protected abstract boolean evaluatePreOutput(Actor var1);

    protected abstract boolean evaluatePostOutput(Actor var1, Token var2);

    public boolean triggersPreInput(Actor actor, Token token) {
        return this.m_OnPreInput && this.evaluatePreInput(actor, token);
    }

    public boolean triggersPostInput(Actor actor) {
        return this.m_OnPostInput && this.evaluatePostInput(actor);
    }

    public boolean triggersPreExecute(Actor actor) {
        return this.m_OnPreExecute && this.evaluatePreExecute(actor);
    }

    public boolean triggersPostExecute(Actor actor) {
        return this.m_OnPostExecute && this.evaluatePostExecute(actor);
    }

    public boolean triggersPreOutput(Actor actor) {
        return this.m_OnPreOutput && this.evaluatePreOutput(actor);
    }

    public boolean triggersPostOutput(Actor actor, Token token) {
        return this.m_OnPostOutput && this.evaluatePostOutput(actor, token);
    }
}

