/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.NamedCounter;
import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.control.StorageUser;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.CheckProcessor;
import adams.flow.processor.GraphicalOutputProducingProcessor;
import adams.gui.dialog.TextPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CheckStorageUsage
extends AbstractActorProcessor
implements GraphicalOutputProducingProcessor,
CheckProcessor {
    private static final long serialVersionUID = 737084782888325641L;
    protected boolean m_OutputCounts;
    protected NamedCounter m_UsageCount;
    protected NamedCounter m_SetCount;
    protected String m_Warnings;

    @Override
    public String globalInfo() {
        return "Performs a 'soft' check whether storage names in use are actually set somewhere in the flow.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UsageCount = new NamedCounter();
        this.m_SetCount = new NamedCounter();
        this.m_Warnings = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-counts", "outputCounts", false);
    }

    public void setOutputCounts(boolean value) {
        this.m_OutputCounts = value;
        this.reset();
    }

    public boolean getOutputCounts() {
        return this.m_OutputCounts;
    }

    public String outputCountsTipText() {
        return "If enabled, the counts get output regardless of warnings.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        ArrayList<String> vars;
        this.m_UsageCount.clear();
        this.m_SetCount.clear();
        this.m_Warnings = null;
        actor.getOptionManager().traverse(new OptionTraverser(){

            protected void incrementSetCount(Object obj) {
                if (obj.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(obj); ++i) {
                        this.incrementSetCount(Array.get(obj, i));
                    }
                } else if (obj instanceof StorageName) {
                    CheckStorageUsage.this.m_SetCount.next(((StorageName)obj).getValue());
                }
            }

            protected void incrementUsageCount(Object obj) {
                if (obj.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(obj); ++i) {
                        this.incrementUsageCount(Array.get(obj, i));
                    }
                } else if (obj instanceof StorageName) {
                    CheckStorageUsage.this.m_UsageCount.next(((StorageName)obj).getValue());
                }
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                if (option.getOptionHandler() instanceof StorageUpdater && option.getBaseClass() == StorageName.class) {
                    if (((StorageUpdater)((Object)option.getOptionHandler())).isUpdatingStorage()) {
                        this.incrementSetCount(option.getCurrentValue());
                    }
                    return;
                }
                if (option.getOptionHandler() instanceof StorageUser && option.getBaseClass() == StorageName.class) {
                    if (((StorageUser)((Object)option.getOptionHandler())).isUsingStorage()) {
                        this.incrementUsageCount(option.getCurrentValue());
                    }
                    return;
                }
                if (option.getBaseClass() == StorageName.class) {
                    this.incrementUsageCount(option.getCurrentValue());
                }
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                if (obj instanceof Actor) {
                    return !((Actor)obj).getSkip() && this.canRecurse(obj.getClass());
                }
                return this.canRecurse(obj.getClass());
            }
        });
        HashSet<String> used = new HashSet<String>(this.m_UsageCount.nameSet());
        Set<String> set = this.m_SetCount.nameSet();
        used.removeAll(set);
        if (used.size() > 0) {
            vars = new ArrayList<String>(used);
            Collections.sort(vars);
            this.m_Warnings = Utils.flatten(vars, "\n");
        }
        if (this.m_OutputCounts) {
            this.m_Warnings = this.m_Warnings == null ? "" : this.m_Warnings + "\n\n";
            this.m_Warnings = this.m_Warnings + "Name: #Set/#Use\n";
            HashSet<String> combined = new HashSet<String>();
            combined.addAll(this.m_UsageCount.nameSet());
            combined.addAll(this.m_SetCount.nameSet());
            vars = new ArrayList(combined);
            Collections.sort(vars);
            for (String var : vars) {
                this.m_Warnings = this.m_Warnings + var + ": " + this.m_SetCount.current(var) + "/" + this.m_UsageCount.current(var) + "\n";
            }
        }
    }

    @Override
    public String getWarningHeader() {
        return "The following storage names were never set:";
    }

    @Override
    public String getWarnings() {
        return this.m_Warnings;
    }

    @Override
    public boolean hasGraphicalOutput() {
        return this.m_Warnings != null;
    }

    @Override
    public String getTitle() {
        return "Storage check";
    }

    @Override
    public Component getGraphicalOutput() {
        TextPanel result = new TextPanel();
        result.setTitle("Storage check");
        result.setPreferredSize(new Dimension(400, 300));
        result.setEditable(false);
        if (this.m_Warnings != null) {
            result.setContent(this.m_Warnings);
        }
        result.setInfoText(this.getWarningHeader());
        return result;
    }
}

