/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.data.io.output.AbstractTextWriter;
import adams.data.io.output.NullWriter;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.goe.FontEditor;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractTextualDisplay
extends AbstractDisplay
implements MenuBarProvider,
TextSupplier,
SendToActionSupporter {
    private static final long serialVersionUID = 3852563073987265768L;
    protected AbstractTextWriter m_Writer;
    protected Font m_Font;
    protected boolean m_AlwaysClear;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileClear;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected transient TextFileChooser m_FileChooser;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("font", "font", this.getDefaultFont());
        if (this.supportsClear()) {
            this.m_OptionManager.add("always-clear", "alwaysClear", false);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Writer = new NullWriter();
    }

    protected TextFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            TextFileChooser fileChooser = new TextFileChooser();
            ExtensionFileFilter filter = null;
            if (this instanceof TextSupplier) {
                filter = this.getCustomTextFileFilter();
            }
            if (filter != null) {
                fileChooser.resetChoosableFileFilters();
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setFileFilter(filter);
                fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            }
            this.m_FileChooser = fileChooser;
        }
        return this.m_FileChooser;
    }

    @Override
    public String getQuickInfo() {
        return super.getQuickInfo() + QuickInfoHelper.toString((OptionHandler)this, "font", FontEditor.toString(null, this.m_Font), ", font: ");
    }

    public void setWriter(AbstractTextWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractTextWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for storing the textual output.";
    }

    protected Font getDefaultFont() {
        return new Font("Monospaced", 0, 12);
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font of the dialog.";
    }

    public void setAlwaysClear(boolean value) {
        this.m_AlwaysClear = value;
        this.reset();
    }

    public boolean getAlwaysClear() {
        return this.m_AlwaysClear;
    }

    public String alwaysClearTipText() {
        return "If enabled, the display is always cleared before processing a token.";
    }

    protected JMenu createFileMenu() {
        JMenuItem menuitem;
        JMenu result = new JMenu("File");
        result.setMnemonic('F');
        result.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractTextualDisplay.this.updateMenu();
            }
        });
        if (this.supportsClear()) {
            menuitem = new JMenuItem("Clear");
            result.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon("new.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractTextualDisplay.this.clear();
                }
            });
            this.m_MenuItemFileClear = menuitem;
        }
        menuitem = new JMenuItem("Save as...");
        result.add(menuitem);
        menuitem.setMnemonic('a');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTextualDisplay.this.saveAs();
            }
        });
        this.m_MenuItemFileSaveAs = menuitem;
        result.addSeparator();
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, result)) {
            result.addSeparator();
        }
        menuitem = new JMenuItem("Close");
        result.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTextualDisplay.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    protected int indexOfMenuItem(JMenu menu, JMenuItem menuitem) {
        int result = -1;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (menu.getItem(i) != menuitem) continue;
            result = i;
            break;
        }
        return result;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        result.add(this.createFileMenu());
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        String text = this.supplyText();
        int len = text == null ? 0 : text.length();
        if (this.supportsClear()) {
            this.m_MenuItemFileClear.setEnabled(len > 0);
        }
        this.m_MenuItemFileSaveAs.setEnabled(len > 0);
    }

    protected boolean supportsClear() {
        return false;
    }

    protected void clear() {
    }

    protected void saveAs() {
        int retVal = this.getFileChooser().showSaveDialog(this.m_Panel);
        if (retVal != 0) {
            return;
        }
        String msg = FileUtils.writeToFileMsg(this.getFileChooser().getSelectedFile().getAbsolutePath(), this.supplyText(), false, this.getFileChooser().getEncoding());
        if (msg != null) {
            this.getLogger().severe("Error saving text to '" + this.getFileChooser().getSelectedFile() + "':\n" + msg);
        }
    }

    protected void close() {
        this.m_Panel.closeParent();
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        return null;
    }

    @Override
    public abstract String supplyText();

    @Override
    protected void preDisplay(Token token) {
        if (this.supportsClear() && this.getAlwaysClear()) {
            this.clear();
        }
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.isHeadless()) {
            System.out.println("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n");
            System.out.println(this.m_InputToken.getPayload());
        } else {
            result = super.doExecute();
        }
        return result;
    }

    @Override
    protected void cleanUpGUI() {
        super.cleanUpGUI();
        this.m_MenuBar = null;
        this.m_MenuItemFileClear = null;
        this.m_MenuItemFileSaveAs = null;
        this.m_MenuItemFileClose = null;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_FileChooser = null;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{String.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(String.class, cls);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        String result = null;
        if (SendToActionUtils.isAvailable(String.class, cls) && (result = this.supplyText()).length() == 0) {
            result = null;
        }
        return result;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        if (!(this.m_Writer instanceof NullWriter) && this.supplyText() != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractTextualDisplay.this.m_Writer.write(AbstractTextualDisplay.this.supplyText(), null);
                    }
                    catch (Exception e) {
                        AbstractTextualDisplay.this.handleException("Failed to write textual output", e);
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }
}

