/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.sink.AbstractFileWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class MergeFiles
extends AbstractFileWriter {
    private static final long serialVersionUID = -6717503477934358351L;

    @Override
    public String globalInfo() {
        return "Combines the incoming files in a single one.";
    }

    @Override
    public String outputFileTipText() {
        return "The output file containing the combined content.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String[].class, File[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        PlaceholderFile[] files = FileUtils.toPlaceholderFileArray(this.m_InputToken.getPayload());
        char[] buffer = new char[1024];
        try {
            FileWriter writer = new FileWriter(this.m_OutputFile.getAbsoluteFile());
            for (int i = 0; i < files.length; ++i) {
                int read;
                FileReader reader = new FileReader(files[i].getAbsoluteFile());
                while ((read = reader.read(buffer)) > -1) {
                    writer.write(buffer, 0, read);
                    if (!this.isStopped()) continue;
                }
                reader.close();
                writer.flush();
                if (this.isStopped()) break;
            }
            writer.close();
        }
        catch (Exception e) {
            result = this.handleException("Failed to merge files: ", e);
        }
        return result;
    }
}

