/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.flow.sink.sequenceplotter.AbstractErrorPaintlet;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;

public class ErrorBandPaintlet
extends AbstractErrorPaintlet {
    private static final long serialVersionUID = -713940308371660030L;
    protected int m_Alpha;
    protected HashMap<Color, Color> m_BandColors;

    @Override
    public String globalInfo() {
        return "Paints a 'band' (or polygon) using the errors as the corners.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_BandColors = new HashMap();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_BandColors.clear();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("alpha", "alpha", 63, 0, 255);
    }

    public void setAlpha(int value) {
        if (value >= 0 && value <= 255) {
            this.m_Alpha = value;
            this.reset();
        } else {
            this.getLogger().warning("Alpha must satisfy 0 <= x <= 255, provided: " + value);
        }
    }

    public int getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "The alpha value to use for the band.";
    }

    @Override
    protected void drawData(Graphics g, SequencePlotSequence data, Color color) {
        if (!this.m_BandColors.containsKey(color)) {
            this.m_BandColors.put(color, new Color(color.getRed(), color.getGreen(), color.getBlue(), this.m_Alpha));
        }
        g.setColor(this.m_BandColors.get(color));
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        TIntArrayList x = new TIntArrayList();
        TIntArrayList y = new TIntArrayList();
        for (Object o : data.toList()) {
            double toY;
            double fromY;
            if (!(o instanceof SequencePlotPoint)) continue;
            SequencePlotPoint point = (SequencePlotPoint)o;
            Double[] error = point.getErrorY();
            if (error.length == 1) {
                fromY = point.getY() - error[0];
                toY = point.getY() + error[0];
            } else {
                fromY = error[0];
                toY = error[1];
            }
            x.add(axisX.valueToPos(point.getX()));
            y.add(axisY.valueToPos(fromY));
            x.insert(0, axisX.valueToPos(point.getX()));
            y.insert(0, axisY.valueToPos(toY));
        }
        g.fillPolygon(x.toArray(), y.toArray(), x.size());
    }
}

