/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.flow.sink.sequenceplotter.AbstractMarkerPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class VerticalMarkers
extends AbstractMarkerPaintlet {
    private static final long serialVersionUID = -7354044974316978487L;

    @Override
    public String globalInfo() {
        return "Draws vertical markers on the sequence plot panel.";
    }

    @Override
    protected void drawData(Graphics g, XYSequence data, Color color) {
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        for (int i = 0; i <= data.size() - 1; ++i) {
            XYSequencePoint curr = (XYSequencePoint)points.get(i);
            int currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
            g.drawLine(currX, axisY.valueToPos(axisY.getActualMinimum()), currX, axisY.valueToPos(axisY.getActualMaximum()));
        }
    }
}

