/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class GetEnvironmentVariable
extends AbstractSimpleSource {
    private static final long serialVersionUID = -1036403425216584221L;
    protected String m_Variable;
    protected String m_Value;

    @Override
    public String globalInfo() {
        return "Outputs the value of the specified environment variable.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable", "variable", "");
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "variable", this.m_Variable, "Variable: ");
    }

    public void setVariable(String value) {
        this.m_Variable = value;
        this.reset();
    }

    public String getVariable() {
        return this.m_Variable;
    }

    public String variableTipText() {
        return "The name of the environment variable to get.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Value = null;
    }

    @Override
    protected String doExecute() {
        this.m_Value = System.getenv(this.m_Variable);
        if (this.m_Value != null) {
            this.m_OutputToken = new Token(this.m_Value);
        }
        return null;
    }
}

