/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class GetSystemProperty
extends AbstractSimpleSource {
    private static final long serialVersionUID = -1036403425216584221L;
    protected String m_Property;
    protected String m_Value;

    @Override
    public String globalInfo() {
        return "Outputs the value of the specified Java system property.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("property", "property", "");
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "property", this.m_Property, "Property: ");
    }

    public void setProperty(String value) {
        this.m_Property = value;
        this.reset();
    }

    public String getProperty() {
        return this.m_Property;
    }

    public String propertyTipText() {
        return "The name of the Java system property to get.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Value = null;
    }

    @Override
    protected String doExecute() {
        this.m_Value = System.getProperty(this.m_Property);
        if (this.m_Value != null) {
            this.m_OutputToken = new Token(this.m_Value);
        }
        return null;
    }
}

