/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.transformer.HashSetInit;
import java.util.ArrayList;
import java.util.Collections;

public class HashSet
extends AbstractSimpleSource {
    private static final long serialVersionUID = -4888807180866059350L;
    public static final String COLUMN_VALUE = "Value";
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Outputs the specified hashset as spreadsheet, with one column called 'Value'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("hashset"));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the hashset in the internal storage.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "HashSet '" + this.m_StorageName + "' not available! Not initialized with " + HashSetInit.class.getName() + "?";
        } else {
            java.util.HashSet lookup = (java.util.HashSet)this.getStorageHandler().getStorage().get(this.m_StorageName);
            SpreadSheet sheet = new SpreadSheet();
            sheet.setName(this.m_StorageName.getValue());
            sheet.getHeaderRow().addCell("v").setContent(COLUMN_VALUE);
            ArrayList values = new ArrayList(lookup);
            Collections.sort(values);
            for (Object value : values) {
                DataRow row = sheet.addRow();
                row.addCell("v").setContent(value.toString());
            }
            this.m_OutputToken = new Token(sheet);
        }
        return result;
    }
}

