/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractExternalActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class ExternalTransformer
extends AbstractExternalActor
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 8557732787822426844L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Transformer that executes an external transformer actor stored on disk.";
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String setUpExternalActor() {
        String result = super.setUpExternalActor();
        if (result == null && !ActorUtils.isTransformer(this.m_ExternalActor)) {
            result = "External actor '" + this.m_ActorFile.getAbsolutePath() + "' is not a transformer!";
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.m_ExternalActor != null) {
            return ((InputConsumer)((Object)this.m_ExternalActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    public boolean hasInput() {
        return this.m_InputToken != null;
    }

    @Override
    public Token currentInput() {
        return this.m_InputToken;
    }

    @Override
    public Class[] generates() {
        if (this.m_ExternalActor != null) {
            return ((OutputProducer)((Object)this.m_ExternalActor)).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String preExecuteExternalActorHook() {
        if (this.m_ExternalActor != null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Inputting token in external flow: " + this.m_InputToken);
            }
            ((InputConsumer)((Object)this.m_ExternalActor)).input(this.m_InputToken);
        }
        this.m_InputToken = null;
        return null;
    }

    @Override
    public Token output() {
        if (this.m_ExternalActor != null) {
            return ((OutputProducer)((Object)this.m_ExternalActor)).output();
        }
        return null;
    }

    @Override
    public boolean hasPendingOutput() {
        if (this.m_ExternalActor != null) {
            return ((OutputProducer)((Object)this.m_ExternalActor)).hasPendingOutput();
        }
        return false;
    }
}

