/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.statistics.StatUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class Max
extends AbstractTransformer {
    private static final long serialVersionUID = 2007764064808349672L;
    protected boolean m_ReturnIndex;

    @Override
    public String globalInfo() {
        return "Returns the maximum value from a double/int array or the index of the maximum value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "returnIndex", false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "returnIndex", this.m_ReturnIndex ? "Index" : "Value");
    }

    public void setReturnIndex(boolean value) {
        this.m_ReturnIndex = value;
        this.reset();
    }

    public boolean getReturnIndex() {
        return this.m_ReturnIndex;
    }

    public String returnIndexTipText() {
        return "If set to true, then the index of the maximum is returned instead of the value.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Integer[].class, Double[].class, int[].class, double[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class, Double.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken.getPayload() instanceof Double[]) {
                Number[] doublesO = (Double[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.maxIndex(doublesO))) : new Token((Double)StatUtils.max(doublesO));
            } else if (this.m_InputToken.getPayload() instanceof double[]) {
                double[] doublesP = (double[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.maxIndex(doublesP))) : new Token(StatUtils.max(doublesP));
            } else if (this.m_InputToken.getPayload() instanceof Integer[]) {
                Number[] integersO = (Integer[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.maxIndex(integersO))) : new Token((Integer)StatUtils.max(integersO));
            } else if (this.m_InputToken.getPayload() instanceof int[]) {
                int[] integersP = (int[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.maxIndex(integersP))) : new Token(StatUtils.max(integersP));
            } else {
                result = "Unhandled class: " + Utils.classToString(this.m_InputToken.getPayload().getClass());
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to determing maximum: ", e);
        }
        return result;
    }
}

