/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.conversion.ConversionFromString;
import adams.data.conversion.StringToString;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.PlotContainerUpdater;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SetPlotContainerValue
extends AbstractTransformer {
    private static final long serialVersionUID = 2488434486963278287L;
    protected PlotContainerUpdater.PlotContainerValue m_ContainerValue;
    protected BaseString m_Value;
    protected String m_MetaDataKey;
    protected ConversionFromString m_Conversion;

    @Override
    public String globalInfo() {
        return "Updates a value of a plot container before it is being displayed in the SequencePlotter sink. Usually, you would attach a variable to the 'value' property of this actor, in order to update the specified value of the container with a value that you calculated somewhere else in the flow.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("container-value", "containerValue", (Object)PlotContainerUpdater.PlotContainerValue.PLOT_NAME);
        this.m_OptionManager.add("value", "value", new BaseString("Plot"));
        this.m_OptionManager.add("meta-data-key", "metaDataKey", "");
        this.m_OptionManager.add("conversion", "conversion", new StringToString());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "containerValue", (Object)this.m_ContainerValue);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "value", this.m_Value, ": ");
        String value = QuickInfoHelper.toString((OptionHandler)this, "metaDataKey", this.m_MetaDataKey, ", meta-data: ");
        if (value != null) {
            result = result + value;
            result = result + QuickInfoHelper.toString((OptionHandler)this, "conversion", this.m_Conversion, ", conversion: ");
        }
        return result;
    }

    public void setContainerValue(PlotContainerUpdater.PlotContainerValue value) {
        this.m_ContainerValue = value;
        this.reset();
    }

    public PlotContainerUpdater.PlotContainerValue getContainerValue() {
        return this.m_ContainerValue;
    }

    public String containerValueTipText() {
        return "The type of value to update.";
    }

    public void setValue(BaseString value) {
        this.m_Value = value;
        this.reset();
    }

    public BaseString getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The actual value to use for updating; values for " + (Object)((Object)PlotContainerUpdater.PlotContainerValue.X_VALUE) + " and " + (Object)((Object)PlotContainerUpdater.PlotContainerValue.Y_VALUE) + " get automatically parsed to doubles; " + "in case of " + (Object)((Object)PlotContainerUpdater.PlotContainerValue.PLOT_NAME) + " you can also use " + "variables in the string.";
    }

    public void setMetaDataKey(String value) {
        this.m_MetaDataKey = value;
        this.reset();
    }

    public String getMetaDataKey() {
        return this.m_MetaDataKey;
    }

    public String metaDataKeyTipText() {
        return "The key to use when updating meta-data.";
    }

    public void setConversion(ConversionFromString value) {
        this.m_Conversion = value;
        this.reset();
    }

    public ConversionFromString getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion to apply to the meta-data value string before adding it.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        SequencePlotterContainer cont = (SequencePlotterContainer)this.m_InputToken.getPayload();
        SequencePlotterContainer newCont = (SequencePlotterContainer)cont.getClone();
        switch (this.m_ContainerValue) {
            case PLOT_NAME: {
                newCont.setValue("PlotName", this.getVariables().expand(this.m_Value.getValue()));
                break;
            }
            case X_VALUE: {
                double dvalue = Utils.toDouble(this.m_Value.getValue());
                newCont.setValue("X", dvalue);
                break;
            }
            case Y_VALUE: {
                double dvalue = Utils.toDouble(this.m_Value.getValue());
                newCont.setValue("Y", dvalue);
                break;
            }
            case META_DATA: {
                Object parsed = this.m_Value.getValue();
                if (!(this.m_Conversion instanceof StringToString)) {
                    this.m_Conversion.setInput(parsed);
                    result = this.m_Conversion.convert();
                    if (result == null) {
                        parsed = this.m_Conversion.getOutput();
                    }
                    this.m_Conversion.cleanUp();
                }
                if (result != null) break;
                newCont.addMetaData(this.m_MetaDataKey, parsed);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled container value: " + (Object)((Object)this.m_ContainerValue));
            }
        }
        if (newCont != null) {
            this.m_OutputToken = new Token(newCont);
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }
}

